/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.simple.adapter.impl;

import de.adorsys.datasafe.simple.adapter.api.types.DSDocument;
import de.adorsys.datasafe.simple.adapter.api.types.DocumentContent;
import de.adorsys.datasafe.simple.adapter.api.types.DocumentDirectoryFQN;
import de.adorsys.datasafe.simple.adapter.api.types.DocumentFQN;
import java.util.ArrayList;
import java.util.List;

public class TestHelper {
    public static List<DSDocument> createDocuments(DocumentDirectoryFQN directory, int numberOfDirectories, int numberOfFiles, int depth) {
        ArrayList<DSDocument> list = new ArrayList<DSDocument>();
        TestHelper.createDocuments(directory, numberOfDirectories, numberOfFiles, depth, list);
        return list;
    }

    private static void createDocuments(DocumentDirectoryFQN directory, int numberOfDirectories, int numberOfFiles, int depth, List<DSDocument> list) {
        for (int file = 0; file < numberOfFiles; ++file) {
            list.add(TestHelper.createFile(directory, file));
        }
        if (depth == 0) {
            return;
        }
        for (int dir = 0; dir < numberOfDirectories; ++dir) {
            DocumentDirectoryFQN subdir = directory.addDirectory("subdir_" + dir);
            TestHelper.createDocuments(subdir, numberOfDirectories, numberOfFiles, depth - 1, list);
        }
    }

    private static DSDocument createFile(DocumentDirectoryFQN directoryFQN, int numberOfFile) {
        DocumentFQN documentFQN = directoryFQN.addName("file" + numberOfFile + "txt");
        DocumentContent documentContent = new DocumentContent(("my name is " + documentFQN.toString()).getBytes());
        return new DSDocument(documentFQN, documentContent);
    }
}

