/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.simple.adapter.impl;

import com.amazonaws.services.s3.model.AmazonS3Exception;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadKeyPassword;
import de.adorsys.datasafe.simple.adapter.api.SimpleDatasafeService;
import de.adorsys.datasafe.simple.adapter.api.types.DFSCredentials;
import de.adorsys.datasafe.simple.adapter.api.types.DSDocument;
import de.adorsys.datasafe.simple.adapter.api.types.DSDocumentStream;
import de.adorsys.datasafe.simple.adapter.api.types.DocumentContent;
import de.adorsys.datasafe.simple.adapter.api.types.DocumentDirectoryFQN;
import de.adorsys.datasafe.simple.adapter.api.types.DocumentFQN;
import de.adorsys.datasafe.simple.adapter.api.types.ListRecursiveFlag;
import de.adorsys.datasafe.simple.adapter.impl.InitFromStorageProvider;
import de.adorsys.datasafe.simple.adapter.impl.SimpleDatasafeServiceImpl;
import de.adorsys.datasafe.simple.adapter.impl.TestHelper;
import de.adorsys.datasafe.storage.impl.fs.FileSystemStorageService;
import de.adorsys.datasafe.teststorage.WithStorageProvider;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.NoSuchFileException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import lombok.Generated;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDatasafeAdapterTest
extends WithStorageProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimpleDatasafeAdapterTest.class);
    SimpleDatasafeService simpleDatasafeService;
    UserIDAuth userIDAuth;
    DFSCredentials dfsCredentials;

    void myinit(WithStorageProvider.StorageDescriptor descriptor) {
        this.dfsCredentials = InitFromStorageProvider.dfsFromDescriptor(descriptor);
    }

    @ValueSource
    protected static Stream<Boolean> withOrWithoutEncryption() {
        return Stream.of(Boolean.TRUE, Boolean.FALSE);
    }

    private static Stream<WithStorageProvider.StorageDescriptor> storages() {
        return SimpleDatasafeAdapterTest.allDefaultStorages();
    }

    @BeforeEach
    public void mybefore() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public void mystart() {
        this.simpleDatasafeService = this.dfsCredentials != null ? new SimpleDatasafeServiceImpl(this.dfsCredentials) : new SimpleDatasafeServiceImpl();
        this.userIDAuth = new UserIDAuth(new UserID("peter"), new ReadKeyPassword("password"));
        this.simpleDatasafeService.createUser(this.userIDAuth);
    }

    @AfterEach
    public void myafter() {
        log.info("delete user");
        this.simpleDatasafeService.destroyUser(this.userIDAuth);
    }

    @ParameterizedTest
    @MethodSource(value={"storages"})
    public void justCreateAndDeleteUser(WithStorageProvider.StorageDescriptor descriptor) {
        this.myinit(descriptor);
        this.mystart();
        log.info("test create user and delete user with " + descriptor.getName());
    }

    @ParameterizedTest
    @MethodSource(value={"storages"})
    public void writeAndReadFile(WithStorageProvider.StorageDescriptor descriptor) {
        this.myinit(descriptor);
        this.mystart();
        String content = "content of document";
        String path = "a/b/c.txt";
        DSDocument document = new DSDocument(new DocumentFQN(path), new DocumentContent(content.getBytes()));
        this.simpleDatasafeService.storeDocument(this.userIDAuth, document);
        DSDocument dsDocument = this.simpleDatasafeService.readDocument(this.userIDAuth, new DocumentFQN(path));
        Assertions.assertTrue((boolean)this.simpleDatasafeService.documentExists(this.userIDAuth, document.getDocumentFQN()));
        Assertions.assertFalse((boolean)this.simpleDatasafeService.documentExists(this.userIDAuth, new DocumentFQN("doesnotexist.txt")));
        Assertions.assertArrayEquals((byte[])content.getBytes(), (byte[])dsDocument.getDocumentContent().getValue());
        log.info("the content read is ok");
    }

    @ParameterizedTest
    @MethodSource(value={"storages"})
    void writeAndReadFileWithPasswordChange(WithStorageProvider.StorageDescriptor descriptor) {
        this.myinit(descriptor);
        this.mystart();
        String content = "content of document";
        String path = "a/b/c.txt";
        DSDocument document = new DSDocument(new DocumentFQN(path), new DocumentContent(content.getBytes()));
        this.simpleDatasafeService.storeDocument(this.userIDAuth, document);
        ReadKeyPassword newPassword = new ReadKeyPassword("AAAAAAHHH!");
        this.simpleDatasafeService.changeKeystorePassword(this.userIDAuth, newPassword);
        Assertions.assertThrows(UnrecoverableKeyException.class, () -> this.simpleDatasafeService.readDocument(this.userIDAuth, new DocumentFQN(path)));
        this.userIDAuth = new UserIDAuth(this.userIDAuth.getUserID(), newPassword);
        DSDocument dsDocument = this.simpleDatasafeService.readDocument(this.userIDAuth, new DocumentFQN(path));
        Assertions.assertTrue((boolean)this.simpleDatasafeService.documentExists(this.userIDAuth, document.getDocumentFQN()));
        Assertions.assertFalse((boolean)this.simpleDatasafeService.documentExists(this.userIDAuth, new DocumentFQN("doesnotexist.txt")));
        Assertions.assertArrayEquals((byte[])content.getBytes(), (byte[])dsDocument.getDocumentContent().getValue());
        log.info("the content read is ok");
    }

    @ParameterizedTest
    @MethodSource(value={"storages"})
    public void writeAndReadFileWithSlash(WithStorageProvider.StorageDescriptor descriptor) {
        this.myinit(descriptor);
        this.mystart();
        String content = "content of document";
        String path = "/a/b/c.txt";
        DSDocument document = new DSDocument(new DocumentFQN(path), new DocumentContent(content.getBytes()));
        this.simpleDatasafeService.storeDocument(this.userIDAuth, document);
        DSDocument dsDocument = this.simpleDatasafeService.readDocument(this.userIDAuth, new DocumentFQN(path));
        Assertions.assertTrue((boolean)this.simpleDatasafeService.documentExists(this.userIDAuth, document.getDocumentFQN()));
        Assertions.assertFalse((boolean)this.simpleDatasafeService.documentExists(this.userIDAuth, new DocumentFQN("doesnotexist.txt")));
        Assertions.assertArrayEquals((byte[])content.getBytes(), (byte[])dsDocument.getDocumentContent().getValue());
        log.info("the content read is ok");
    }

    @ParameterizedTest
    @MethodSource(value={"storages"})
    public void writeAndReadFiles(WithStorageProvider.StorageDescriptor descriptor) {
        this.myinit(descriptor);
        this.mystart();
        DocumentDirectoryFQN root = new DocumentDirectoryFQN("affe");
        List<DSDocument> list = TestHelper.createDocuments(root, 2, 2, 3);
        ArrayList<DocumentFQN> created = new ArrayList<DocumentFQN>();
        for (DSDocument dsDocument : list) {
            log.debug("store " + dsDocument.getDocumentFQN().toString());
            this.simpleDatasafeService.storeDocument(this.userIDAuth, dsDocument);
            created.add(dsDocument.getDocumentFQN());
            Assertions.assertTrue((boolean)this.simpleDatasafeService.documentExists(this.userIDAuth, dsDocument.getDocumentFQN()));
        }
        List listFound = this.simpleDatasafeService.list(this.userIDAuth, root, ListRecursiveFlag.TRUE);
        this.show("full list recursive ", listFound);
        Assertions.assertTrue((boolean)created.containsAll(listFound));
        Assertions.assertTrue((boolean)listFound.containsAll(created));
        listFound = this.simpleDatasafeService.list(this.userIDAuth, root.addDirectory("subdir_0").addDirectory("subdir_0"), ListRecursiveFlag.TRUE);
        this.show("subdir 0 subdir 0 recursive", listFound);
        Assertions.assertEquals((int)6, (int)listFound.size());
        listFound = this.simpleDatasafeService.list(this.userIDAuth, root.addDirectory("subdir_0").addDirectory("subdir_0"), ListRecursiveFlag.FALSE);
        this.show("subidr 0 subdir 0 non recursive", listFound);
        Assertions.assertEquals((int)2, (int)listFound.size());
        listFound = this.simpleDatasafeService.list(this.userIDAuth, root.addDirectory("subdir_0").addDirectory("//subdir_0//"), ListRecursiveFlag.FALSE);
        this.show("subidr 0 subdir 0 non recursive with more slases", listFound);
        Assertions.assertEquals((int)2, (int)listFound.size());
        DocumentFQN oneDoc = new DocumentFQN("affe/subdir_0/subdir_0/file1txt");
        Assertions.assertTrue((boolean)this.simpleDatasafeService.documentExists(this.userIDAuth, oneDoc));
        this.simpleDatasafeService.deleteDocument(this.userIDAuth, oneDoc);
        Assertions.assertFalse((boolean)this.simpleDatasafeService.documentExists(this.userIDAuth, oneDoc));
        this.simpleDatasafeService.deleteFolder(this.userIDAuth, root.addDirectory("subdir_1"));
        listFound = this.simpleDatasafeService.list(this.userIDAuth, root, ListRecursiveFlag.TRUE);
        this.show("full list recursive after delete subdir 1", listFound);
        Assertions.assertEquals((int)15, (int)listFound.size());
        DocumentFQN otherDoc = new DocumentFQN("affe/subdir_0/subdir_0/file0txt");
        this.simpleDatasafeService.deleteDocument(this.userIDAuth, otherDoc);
        listFound = this.simpleDatasafeService.list(this.userIDAuth, root, ListRecursiveFlag.TRUE);
        this.show("full list recursive after delete one file", listFound);
        Assertions.assertEquals((int)14, (int)listFound.size());
    }

    @ParameterizedTest
    @MethodSource(value={"storages"})
    public void writeAndReadFilesAsStream(WithStorageProvider.StorageDescriptor descriptor) {
        this.myinit(descriptor);
        this.mystart();
        DocumentFQN path = new DocumentFQN("file.txt");
        byte[] bytes = "Bytes".getBytes();
        this.simpleDatasafeService.storeDocumentStream(this.userIDAuth, new DSDocumentStream(path, (InputStream)new ByteArrayInputStream(bytes)));
        DSDocumentStream ds = this.simpleDatasafeService.readDocumentStream(this.userIDAuth, path);
        Assertions.assertArrayEquals((byte[])Streams.readAll((InputStream)ds.getDocumentStream()), (byte[])bytes);
        byte[] otherBytes = "otherBytes".getBytes();
        try (OutputStream os = this.simpleDatasafeService.storeDocumentStream(this.userIDAuth, path);){
            os.write(otherBytes);
        }
        DSDocumentStream otherDs = this.simpleDatasafeService.readDocumentStream(this.userIDAuth, path);
        Assertions.assertArrayEquals((byte[])Streams.readAll((InputStream)otherDs.getDocumentStream()), (byte[])otherBytes);
    }

    @ParameterizedTest
    @MethodSource(value={"storages"})
    public void testTwoUsers(WithStorageProvider.StorageDescriptor descriptor) {
        this.myinit(descriptor);
        this.mystart();
        UserIDAuth userIDAuth2 = new UserIDAuth(new UserID("peter2"), new ReadKeyPassword("password2"));
        this.simpleDatasafeService.createUser(userIDAuth2);
        String content = "content of document";
        String path = "a/b/c.txt";
        DSDocument document = new DSDocument(new DocumentFQN(path), new DocumentContent(content.getBytes()));
        this.simpleDatasafeService.storeDocument(this.userIDAuth, document);
        this.simpleDatasafeService.storeDocument(userIDAuth2, document);
        UserIDAuth wrongPasswordUser1 = new UserIDAuth(this.userIDAuth.getUserID(), new ReadKeyPassword(UUID.randomUUID().toString()));
        Assertions.assertThrows(UnrecoverableKeyException.class, () -> this.simpleDatasafeService.readDocument(wrongPasswordUser1, new DocumentFQN(path)));
        UserIDAuth wrongPasswordUser2 = new UserIDAuth(userIDAuth2.getUserID(), new ReadKeyPassword(UUID.randomUUID().toString()));
        Assertions.assertThrows(UnrecoverableKeyException.class, () -> this.simpleDatasafeService.readDocument(wrongPasswordUser2, new DocumentFQN(path)));
        DSDocument dsDocument = this.simpleDatasafeService.readDocument(this.userIDAuth, new DocumentFQN(path));
        Assertions.assertArrayEquals((byte[])content.getBytes(), (byte[])dsDocument.getDocumentContent().getValue());
        DSDocument dsDocument2 = this.simpleDatasafeService.readDocument(userIDAuth2, new DocumentFQN(path));
        Assertions.assertArrayEquals((byte[])content.getBytes(), (byte[])dsDocument2.getDocumentContent().getValue());
        this.simpleDatasafeService.destroyUser(userIDAuth2);
        if (descriptor.getStorageService().get() instanceof FileSystemStorageService) {
            Assertions.assertThrows(NoSuchFileException.class, () -> this.simpleDatasafeService.documentExists(userIDAuth2, document.getDocumentFQN()));
        } else {
            Assertions.assertThrows(AmazonS3Exception.class, () -> this.simpleDatasafeService.documentExists(userIDAuth2, document.getDocumentFQN()));
        }
        Assertions.assertFalse((boolean)this.simpleDatasafeService.userExists(userIDAuth2.getUserID()));
        Assertions.assertTrue((boolean)this.simpleDatasafeService.documentExists(this.userIDAuth, document.getDocumentFQN()));
    }

    private void show(String message, List<DocumentFQN> listFound) {
        log.debug("---------------------------------");
        log.debug(message);
        for (DocumentFQN doc : listFound) {
            log.debug("found:" + doc);
        }
    }
}

