/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.runtimedelegate;

import de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.inject.Inject;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
public class RuntimeDelegateProcessor
extends AbstractProcessor {
    static final String ANNOTATION_CLASS = "de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate";

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        RuntimeDelegateGenerator generator = new RuntimeDelegateGenerator();
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : annotatedElements) {
                if (element.getKind() != ElementKind.CLASS) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Only classes should be annotated with @de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate", element);
                    return false;
                }
                TypeElement clazz = (TypeElement)element;
                if (clazz.getModifiers().contains((Object)Modifier.FINAL)) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Class should not be final", clazz);
                    return false;
                }
                ExecutableElement ctor = this.findAnnotatedConstructor(clazz, Inject.class);
                if (null == ctor) continue;
                generator.generate(clazz, OverridesRegistry.class, ctor, Collections.singleton(Inject.class), this.processingEnv.getFiler());
            }
        }
        return false;
    }

    private <A extends Annotation> ExecutableElement findAnnotatedConstructor(TypeElement element, Class<A> annotation) {
        HashSet<ExecutableElement> annotated = new HashSet<ExecutableElement>();
        for (Element element2 : element.getEnclosedElements()) {
            A onCtor;
            if (element2.getKind() != ElementKind.CONSTRUCTOR || null == (onCtor = element2.getAnnotation(annotation))) continue;
            annotated.add((ExecutableElement)element2);
        }
        if (annotated.size() != 1) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Class should have exactly one @Inject annotation", element);
            return null;
        }
        return (ExecutableElement)annotated.iterator().next();
    }
}

