/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.runtimedelegate;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.IOError;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.processing.Filer;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

class RuntimeDelegateGenerator {
    private static final String CLASS_PURPOSE_COMMENT = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used.";
    private static final String OVERRIDE_WITH_PURPOSE_COMMENT = "This is a typesafe function to register overriding class into context.\n";
    private static final String CAPTOR_TYPE_NAME = "ArgumentsCaptor";
    private static final String CAPTOR_NAME = "argumentsCaptor";
    private static final String DELEGATE_NAME = "delegate";

    RuntimeDelegateGenerator() {
    }

    void generate(TypeElement forClass, Class contextClass, ExecutableElement usingConstructor, Set<Class> addAnnotations, Filer filer) {
        TypeSpec.Builder delegator = this.buildDelegatingClass(forClass);
        this.annotateAsGenerated(delegator);
        delegator.superclass(TypeName.get((TypeMirror)forClass.asType()));
        TypeSpec argCaptor = this.addGenericParametersToClassSignature(forClass, usingConstructor, delegator);
        delegator.addType(argCaptor);
        delegator.addField(this.addDelegateField(forClass));
        this.addSuperClassOverrides(delegator, forClass);
        delegator.addMethod(this.constructor(forClass, contextClass, usingConstructor, addAnnotations));
        delegator.addMethod(this.overrideWith(forClass, contextClass, argCaptor));
        JavaFile javaFile = JavaFile.builder((String)ClassName.get((TypeElement)forClass).packageName(), (TypeSpec)delegator.build()).indent("    ").build();
        try {
            javaFile.writeTo(filer);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    private TypeSpec addGenericParametersToClassSignature(TypeElement forClass, ExecutableElement usingConstructor, TypeSpec.Builder delegator) {
        List<TypeVariableName> typeVariableNames = forClass.getTypeParameters().stream().map(TypeVariableName::get).collect(Collectors.toList());
        delegator.addTypeVariables(typeVariableNames);
        return this.addArgsCaptor(usingConstructor, typeVariableNames);
    }

    private FieldSpec addDelegateField(TypeElement forClass) {
        return FieldSpec.builder((TypeName)TypeName.get((TypeMirror)forClass.asType()), (String)DELEGATE_NAME, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    private void annotateAsGenerated(TypeSpec.Builder delegator) {
        delegator.addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", CodeBlock.of((String)"$S", (Object[])new Object[]{RuntimeDelegateGenerator.class.getCanonicalName()})).addMember("comments", CodeBlock.of((String)"$S", (Object[])new Object[]{CLASS_PURPOSE_COMMENT})).build());
    }

    private TypeSpec.Builder buildDelegatingClass(TypeElement forClass) {
        return TypeSpec.classBuilder((String)(forClass.getSimpleName().toString() + "RuntimeDelegatable")).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    private void addSuperClassOverrides(TypeSpec.Builder toClass, TypeElement baseClass) {
        baseClass.getEnclosedElements().stream().filter(it -> it instanceof ExecutableElement).filter(it -> it.getKind() == ElementKind.METHOD).filter(it -> !it.getModifiers().contains((Object)Modifier.PRIVATE)).forEach(it -> {
            MethodSpec overriddenBase = MethodSpec.overriding((ExecutableElement)((ExecutableElement)it)).build();
            MethodSpec.Builder overridden = MethodSpec.overriding((ExecutableElement)((ExecutableElement)it));
            overridden.addCode(this.delegateToIfOverrideIsPresent(overriddenBase)).build();
            toClass.addMethod(overridden.build());
        });
    }

    private CodeBlock delegateToIfOverrideIsPresent(MethodSpec target) {
        String params = target.parameters.stream().map(it -> it.name).collect(Collectors.joining(", "));
        String returnStatementIfNeeded = TypeName.VOID.equals((Object)target.returnType) ? "" : "return ";
        return CodeBlock.builder().beginControlFlow("if (null == delegate)", new Object[0]).addStatement(returnStatementIfNeeded + "super.$N(" + params + ")", new Object[]{target}).nextControlFlow("else", new Object[0]).addStatement(returnStatementIfNeeded + DELEGATE_NAME + ".$N(" + params + ")", new Object[]{target}).endControlFlow().build();
    }

    private TypeSpec addArgsCaptor(ExecutableElement usingConstructor, List<TypeVariableName> typeVariables) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)CAPTOR_TYPE_NAME).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addTypeVariables(typeVariables);
        MethodSpec.Builder ctor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE});
        usingConstructor.getParameters().forEach(it -> {
            FieldSpec argCaptor = FieldSpec.builder((TypeName)TypeName.get((TypeMirror)it.asType()), (String)RuntimeDelegateGenerator.firstCharToLowerCase(it.getSimpleName().toString()), (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
            ctor.addParameter(argCaptor.type, argCaptor.name, new Modifier[0]);
            ctor.addStatement("this.$N = $N", new Object[]{argCaptor.name, argCaptor.name});
            builder.addField(argCaptor);
            builder.addMethod(MethodSpec.methodBuilder((String)("get" + RuntimeDelegateGenerator.firstCharToUpperCase(argCaptor.name))).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(argCaptor.type).addCode(CodeBlock.builder().addStatement("return $N", new Object[]{argCaptor}).build()).build());
        });
        return builder.addMethod(ctor.build()).build();
    }

    private MethodSpec constructor(TypeElement forClass, Class contextClass, ExecutableElement usingConstructor, Set<Class> addAnnotations) {
        MethodSpec.Builder method = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        ParameterSpec contextParam = ParameterSpec.builder((TypeName)ClassName.get((Class)contextClass), (String)"context", (Modifier[])new Modifier[0]).addAnnotation(Nullable.class).build();
        method.addParameter(contextParam);
        usingConstructor.getParameters().forEach(it -> method.addParameter(TypeName.get((TypeMirror)it.asType()), RuntimeDelegateGenerator.firstCharToLowerCase(it.getSimpleName().toString()), new Modifier[0]).addAnnotations((Iterable)it.getAnnotationMirrors().stream().map(AnnotationSpec::get).collect(Collectors.toList())));
        addAnnotations.forEach(arg_0 -> ((MethodSpec.Builder)method).addAnnotation(arg_0));
        CodeBlock.Builder block = CodeBlock.builder();
        block.addStatement("super(" + this.computeOriginalCtorArgs(usingConstructor) + ")", new Object[0]);
        this.createCaptorWithNew(block, usingConstructor);
        block.addStatement("delegate = $N != null ? $N.findOverride($T.class, argumentsCaptor) : null", new Object[]{contextParam, contextParam, forClass.getTypeParameters().isEmpty() ? forClass : ClassName.get((TypeElement)forClass)});
        method.addCode(block.build());
        method.addJavadoc("@param context Context class to search for overrides.\n", new Object[0]);
        return method.build();
    }

    private MethodSpec overrideWith(TypeElement forClass, Class context, TypeSpec argsCaptor) {
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)"overrideWith").addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.STATIC}).returns(TypeName.VOID);
        ClassName captor = ClassName.bestGuess((String)argsCaptor.name);
        methodSpec.addParameter((TypeName)ClassName.get((Class)context), "context", new Modifier[0]);
        methodSpec.addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{captor, ClassName.get((TypeElement)forClass)}), "ctorCaptor", new Modifier[0]);
        methodSpec.addStatement("context.override($T.class, args -> ctorCaptor.apply(($T) args))", new Object[]{ClassName.get((TypeElement)forClass), captor});
        methodSpec.addJavadoc(OVERRIDE_WITH_PURPOSE_COMMENT, new Object[0]);
        return methodSpec.build();
    }

    private void createCaptorWithNew(CodeBlock.Builder block, ExecutableElement usingConstructor) {
        block.addStatement(String.format("%s %s = new %s(%s)", CAPTOR_TYPE_NAME, CAPTOR_NAME, CAPTOR_TYPE_NAME, this.computeOriginalCtorArgs(usingConstructor)), new Object[0]);
    }

    private String computeOriginalCtorArgs(ExecutableElement usingConstructor) {
        return usingConstructor.getParameters().stream().map(it -> RuntimeDelegateGenerator.firstCharToLowerCase(it.getSimpleName().toString())).collect(Collectors.joining(", "));
    }

    private static String firstCharToLowerCase(String str) {
        char[] asChars = str.toCharArray();
        asChars[0] = Character.toLowerCase(asChars[0]);
        return new String(asChars);
    }

    private static String firstCharToUpperCase(String str) {
        char[] asChars = str.toCharArray();
        asChars[0] = Character.toUpperCase(asChars[0]);
        return new String(asChars);
    }
}

