/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.rest.impl.security;

import com.google.common.base.Strings;
import de.adorsys.datasafe.rest.impl.security.SecurityProperties;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.security.SignatureException;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

public class JwtAuthorizationFilter
extends BasicAuthenticationFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JwtAuthorizationFilter.class);
    private final SecurityProperties securityProperties;

    public JwtAuthorizationFilter(AuthenticationManager authenticationManager, SecurityProperties securityProperties) {
        super(authenticationManager);
        this.securityProperties = securityProperties;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        UsernamePasswordAuthenticationToken authentication = this.getAuthentication(request);
        String header = request.getHeader("token");
        if (Strings.isNullOrEmpty((String)header) || !header.startsWith("Bearer ")) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private UsernamePasswordAuthenticationToken getAuthentication(HttpServletRequest request) {
        String token = request.getHeader("token");
        if (Strings.isNullOrEmpty((String)token)) {
            return null;
        }
        try {
            return this.tryAuthenticate(token);
        }
        catch (ExpiredJwtException exception) {
            log.warn("Request to parse expired JWT : {} failed", (Object)token, (Object)exception);
        }
        catch (UnsupportedJwtException exception) {
            log.warn("Request to parse unsupported JWT : {} failed", (Object)token, (Object)exception);
        }
        catch (MalformedJwtException exception) {
            log.warn("Request to parse invalid JWT : {} failed", (Object)token, (Object)exception);
        }
        catch (SignatureException exception) {
            log.warn("Request to parse JWT with invalid signature : {} failed", (Object)token, (Object)exception);
        }
        catch (IllegalArgumentException exception) {
            log.warn("Request to parse empty or null JWT : {} failed", (Object)token, (Object)exception);
        }
        return null;
    }

    private UsernamePasswordAuthenticationToken tryAuthenticate(String token) {
        byte[] signingKey = this.securityProperties.getJwtSecret().getBytes();
        Jws parsedToken = Jwts.parser().setSigningKey(signingKey).parseClaimsJws(token.replace("Bearer ", ""));
        String username = ((Claims)parsedToken.getBody()).getSubject();
        List authorities = ((List)((Claims)parsedToken.getBody()).get((Object)"rol")).stream().map(authority -> new SimpleGrantedAuthority((String)authority)).collect(Collectors.toList());
        if (!Strings.isNullOrEmpty((String)username)) {
            return new UsernamePasswordAuthenticationToken((Object)username, null, authorities);
        }
        return null;
    }
}

