/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.rest.impl.controller;

import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import de.adorsys.datasafe.directory.api.types.StorageCredentials;
import de.adorsys.datasafe.directory.api.types.UserPrivateProfile;
import de.adorsys.datasafe.directory.api.types.UserPublicProfile;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.rest.impl.controller.ReadKeyPasswordHelper;
import de.adorsys.datasafe.rest.impl.dto.NewPasswordDTO;
import de.adorsys.datasafe.rest.impl.dto.StorageCredsDTO;
import de.adorsys.datasafe.rest.impl.dto.UserDTO;
import de.adorsys.datasafe.rest.impl.dto.UserPrivateProfileDTO;
import de.adorsys.datasafe.rest.impl.dto.UserPublicProfileDTO;
import de.adorsys.datasafe.rest.impl.exceptions.UserDoesNotExistsException;
import de.adorsys.datasafe.rest.impl.exceptions.UserExistsException;
import de.adorsys.datasafe.types.api.resource.StorageIdentifier;
import de.adorsys.datasafe.types.api.types.ReadKeyPassword;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import lombok.Generated;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user"}, produces={"application/json"})
@Api(description="Create and delete users")
public class UserController {
    private final DefaultDatasafeServices dataSafeService;

    @PutMapping
    @ApiOperation(value="Creates new user")
    @ApiResponses(value={@ApiResponse(code=200, message="User successfully created"), @ApiResponse(code=400, message="User already exists")})
    public void createUser(@Validated @RequestBody UserDTO userDTO) {
        ReadKeyPassword readKeyPassword = ReadKeyPasswordHelper.getForString((String)userDTO.getPassword());
        UserIDAuth auth = new UserIDAuth(new UserID(userDTO.getUserName()), readKeyPassword);
        if (this.dataSafeService.userProfile().userExists(auth.getUserID())) {
            throw new UserExistsException("user '" + auth.getUserID().getValue() + "' already exists");
        }
        this.dataSafeService.userProfile().registerUsingDefaults(auth);
    }

    @PostMapping(value={"/password"})
    @ApiOperation(value="Change users' password")
    public void changePassword(@RequestHeader String user, @RequestHeader String password, @Validated @RequestBody NewPasswordDTO newPassword) {
        ReadKeyPassword readKeyPassword = ReadKeyPasswordHelper.getForString((String)password);
        UserIDAuth auth = new UserIDAuth(new UserID(user), readKeyPassword);
        this.dataSafeService.userProfile().updateReadKeyPassword(auth, ReadKeyPasswordHelper.getForString((String)newPassword.getNewPassword()));
    }

    @GetMapping(value={"/publicProfile"})
    @ApiOperation(value="Reads users' public profile")
    public UserPublicProfileDTO getPublicProfile(@RequestHeader String user, @RequestHeader String password) {
        ReadKeyPassword readKeyPassword = ReadKeyPasswordHelper.getForString((String)password);
        UserIDAuth auth = new UserIDAuth(new UserID(user), readKeyPassword);
        return UserPublicProfileDTO.from((UserPublicProfile)this.dataSafeService.userProfile().publicProfile(auth.getUserID()));
    }

    @GetMapping(value={"/privateProfile"})
    @ApiOperation(value="Reads users' private profile")
    public UserPrivateProfileDTO getPrivateProfile(@RequestHeader String user, @RequestHeader String password) {
        ReadKeyPassword readKeyPassword = ReadKeyPasswordHelper.getForString((String)password);
        UserIDAuth auth = new UserIDAuth(new UserID(user), readKeyPassword);
        return UserPrivateProfileDTO.from((UserPrivateProfile)this.dataSafeService.userProfile().privateProfile(auth));
    }

    @PostMapping(value={"/publicProfile"})
    @ApiOperation(value="Modifies users' public profile")
    public void updatePublicProfile(@RequestHeader String user, @RequestHeader String password, @Validated @RequestBody UserPublicProfileDTO profileDto) {
        ReadKeyPassword readKeyPassword = ReadKeyPasswordHelper.getForString((String)password);
        UserIDAuth auth = new UserIDAuth(new UserID(user), readKeyPassword);
        this.dataSafeService.userProfile().updatePublicProfile(auth, profileDto.toProfile());
    }

    @PostMapping(value={"/privateProfile"})
    @ApiOperation(value="Modifies users' private profile")
    public void updatePrivateProfile(@RequestHeader String user, @RequestHeader String password, @Validated @RequestBody UserPrivateProfileDTO profileDto) {
        ReadKeyPassword readKeyPassword = ReadKeyPasswordHelper.getForString((String)password);
        UserIDAuth auth = new UserIDAuth(new UserID(user), readKeyPassword);
        this.dataSafeService.userProfile().updatePrivateProfile(auth, profileDto.toProfile());
    }

    @PostMapping(value={"/storages"})
    @ApiOperation(value="Adds users' storage id and credentials")
    public void addStorageCredentials(@RequestHeader String user, @RequestHeader String password, @Validated @RequestBody StorageCredsDTO creds) {
        ReadKeyPassword readKeyPassword = ReadKeyPasswordHelper.getForString((String)password);
        UserIDAuth auth = new UserIDAuth(new UserID(user), readKeyPassword);
        this.dataSafeService.userProfile().registerStorageCredentials(auth, new StorageIdentifier(creds.getStorageRegexMatcher()), new StorageCredentials(creds.getUsername(), creds.getPassword()));
    }

    @DeleteMapping(value={"/storages"})
    @ApiOperation(value="Removes users' storage id and credentials")
    public void removeStorageCredentials(@RequestHeader String user, @RequestHeader String password, @RequestHeader String storageId) {
        ReadKeyPassword readKeyPassword = ReadKeyPasswordHelper.getForString((String)password);
        UserIDAuth auth = new UserIDAuth(new UserID(user), readKeyPassword);
        this.dataSafeService.userProfile().deregisterStorageCredentials(auth, new StorageIdentifier(storageId));
    }

    @DeleteMapping
    @ApiOperation(value="Deletes existing user")
    @ApiResponses(value={@ApiResponse(code=200, message="User successfully deleted"), @ApiResponse(code=404, message="User does not exist")})
    public void deleteUser(@RequestHeader String user, @RequestHeader String password) {
        UserIDAuth auth = new UserIDAuth(new UserID(user), ReadKeyPasswordHelper.getForString((String)password));
        if (!this.dataSafeService.userProfile().userExists(auth.getUserID())) {
            throw new UserDoesNotExistsException("user '" + auth.getUserID().getValue() + "' does not exists");
        }
        this.dataSafeService.userProfile().deregister(auth);
    }

    @Generated
    public UserController(DefaultDatasafeServices dataSafeService) {
        this.dataSafeService = dataSafeService;
    }
}

