/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.rest.impl.controller;

import com.amazonaws.services.s3.model.AmazonS3Exception;
import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.rest.impl.controller.ReadKeyPasswordHelper;
import de.adorsys.datasafe.rest.impl.exceptions.UnauthorizedException;
import de.adorsys.datasafe.types.api.actions.ListRequest;
import de.adorsys.datasafe.types.api.actions.ReadRequest;
import de.adorsys.datasafe.types.api.actions.RemoveRequest;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(description="Operations with inbox")
public class InboxController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InboxController.class);
    private final DefaultDatasafeServices dataSafeService;

    @PutMapping(value={"/inbox/document/{path:.*}"}, consumes={"multipart/form-data"})
    @ApiOperation(value="Send document to inbox")
    @ApiResponses(value={@ApiResponse(code=200, message="Document was successfully sent"), @ApiResponse(code=403, message="Access denied")})
    public void writeToInbox(@RequestHeader Set<String> users, @PathVariable String path, @RequestParam(value="file") MultipartFile file) {
        Set toUsers = users.stream().map(UserID::new).collect(Collectors.toSet());
        try (OutputStream os = this.dataSafeService.inboxService().write(WriteRequest.forDefaultPublic(toUsers, (String)path));
             InputStream is = file.getInputStream();){
            StreamUtils.copy((InputStream)is, (OutputStream)os);
        }
        log.debug("Users {}, write to INBOX file: {}", toUsers, (Object)path);
    }

    @GetMapping(value={"/inbox/document/{path:.*}"}, produces={"application/octet-stream"})
    @ApiOperation(value="Read document from inbox")
    @ApiResponses(value={@ApiResponse(code=200, message="Document was successfully read"), @ApiResponse(code=404, message="Document not found")})
    public void readFromInbox(@RequestHeader String user, @RequestHeader String password, @PathVariable String path, HttpServletResponse response) {
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(user), ReadKeyPasswordHelper.getForString((String)password));
        PrivateResource resource = BasePrivateResource.forPrivate((String)path);
        response.addHeader("Content-Type", "application/octet-stream");
        try (InputStream is = this.dataSafeService.inboxService().read(ReadRequest.forPrivate((Object)userIDAuth, (PrivateResource)resource));
             ServletOutputStream os = response.getOutputStream();){
            StreamUtils.copy((InputStream)is, (OutputStream)os);
        }
        log.debug("User {}, read from INBOX file {}", (Object)user, (Object)resource);
    }

    @DeleteMapping(value={"/inbox/document/{path:.*}"})
    @ApiOperation(value="Delete document from inbox")
    @ApiResponses(value={@ApiResponse(code=200, message="Document successfully deleted")})
    public void deleteFromInbox(@RequestHeader String user, @RequestHeader String password, @PathVariable String path) {
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(user), ReadKeyPasswordHelper.getForString((String)password));
        PrivateResource resource = BasePrivateResource.forPrivate((String)path);
        RemoveRequest request = RemoveRequest.forPrivate((Object)userIDAuth, (PrivateResource)resource);
        this.dataSafeService.inboxService().remove(request);
        log.debug("User {}, delete from INBOX file {}", (Object)user, (Object)resource);
    }

    @GetMapping(value={"/inbox/documents/{path:.*}"}, produces={"application/json"})
    @ApiOperation(value="List files in inbox")
    @ApiResponses(value={@ApiResponse(code=200, message="List command successfully completed"), @ApiResponse(code=401, message="Unauthorised")})
    public List<String> listInbox(@RequestHeader String user, @RequestHeader String password, @ApiParam(defaultValue=".") @PathVariable(required=false) String path) {
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(user), ReadKeyPasswordHelper.getForString((String)password));
        path = Optional.ofNullable(path).map(it -> it.replaceAll("^\\.$", "")).orElse("./");
        try {
            List<String> inboxList = this.dataSafeService.inboxService().list(ListRequest.forDefaultPrivate((Object)userIDAuth, (String)path)).map(e -> ((ResolvedResource)e.getResource()).asPrivate().decryptedPath().asString()).collect(Collectors.toList());
            log.debug("User's {} inbox contains {} items", (Object)user, (Object)inboxList.size());
            return inboxList;
        }
        catch (AmazonS3Exception e2) {
            throw new UnauthorizedException("Unauthorized", (Throwable)e2);
        }
    }

    @Generated
    public InboxController(DefaultDatasafeServices dataSafeService) {
        this.dataSafeService = dataSafeService;
    }
}

