/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.rest.impl.controller;

import com.amazonaws.services.s3.model.AmazonS3Exception;
import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.privatestore.api.PasswordClearingInputStream;
import de.adorsys.datasafe.privatestore.api.PasswordClearingOutputStream;
import de.adorsys.datasafe.rest.impl.controller.ReadKeyPasswordHelper;
import de.adorsys.datasafe.rest.impl.exceptions.UnauthorizedException;
import de.adorsys.datasafe.types.api.actions.ListRequest;
import de.adorsys.datasafe.types.api.actions.ReadRequest;
import de.adorsys.datasafe.types.api.actions.RemoveRequest;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import de.adorsys.datasafe.types.api.resource.StorageIdentifier;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(description="Operations with private documents")
public class DocumentController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocumentController.class);
    private final DefaultDatasafeServices datasafeService;

    @GetMapping(value={"/document/{path:.*}"}, produces={"application/octet-stream"})
    @ApiOperation(value="Read document from user's private space")
    @ApiResponses(value={@ApiResponse(code=200, message="Document was successfully read"), @ApiResponse(code=401, message="Document not found")})
    public void readDocument(@RequestHeader String user, @RequestHeader String password, @RequestHeader(defaultValue="DEFAULT") String storageId, @PathVariable String path, HttpServletResponse response) {
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(user), ReadKeyPasswordHelper.getForString((String)password));
        ReadRequest request = ReadRequest.forPrivate((Object)userIDAuth, (StorageIdentifier)new StorageIdentifier(storageId), (String)path);
        response.addHeader("Content-Type", "application/octet-stream");
        try (PasswordClearingInputStream is = this.datasafeService.privateService().read(request);
             ServletOutputStream os = response.getOutputStream();){
            StreamUtils.copy((InputStream)is, (OutputStream)os);
        }
        log.debug("User: {}, read private file from: {}", (Object)user, (Object)password);
    }

    @PutMapping(value={"/document/{path:.*}"}, consumes={"multipart/form-data"})
    @ApiOperation(value="Write document to user's private space")
    @ApiResponses(value={@ApiResponse(code=200, message="Document was successfully written")})
    public void writeDocument(@RequestHeader String user, @RequestHeader String password, @RequestHeader(defaultValue="DEFAULT") String storageId, @PathVariable String path, @RequestParam(value="file") MultipartFile file) {
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(user), ReadKeyPasswordHelper.getForString((String)password));
        WriteRequest request = WriteRequest.forPrivate((Object)userIDAuth, (StorageIdentifier)new StorageIdentifier(storageId), (String)path);
        try (PasswordClearingOutputStream os = this.datasafeService.privateService().write(request);
             InputStream is = file.getInputStream();){
            StreamUtils.copy((InputStream)is, (OutputStream)os);
        }
        log.debug("User: {}, write private file to: {}", (Object)user, (Object)path);
    }

    @GetMapping(value={"/documents/{path:.*}"})
    @ApiOperation(value="List documents in user's private space")
    @ApiResponses(value={@ApiResponse(code=200, message="List command successfully completed"), @ApiResponse(code=401, message="Unauthorised")})
    public List<String> listDocuments(@RequestHeader String user, @RequestHeader String password, @RequestHeader(defaultValue="DEFAULT") String storageId, @ApiParam(defaultValue=".") @PathVariable(required=false) String path) {
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(user), ReadKeyPasswordHelper.getForString((String)password));
        path = Optional.ofNullable(path).map(it -> it.replaceAll("^\\.$", "")).orElse("./");
        try {
            List<String> documentList = this.datasafeService.privateService().list(ListRequest.forPrivate((Object)userIDAuth, (StorageIdentifier)new StorageIdentifier(storageId), (String)path)).map(e -> ((ResolvedResource)e.getResource()).asPrivate().decryptedPath().asString()).collect(Collectors.toList());
            log.debug("List for path {} returned {} items", (Object)path, (Object)documentList.size());
            return documentList;
        }
        catch (AmazonS3Exception e2) {
            throw new UnauthorizedException("Unauthorized", (Throwable)e2);
        }
    }

    @DeleteMapping(value={"/document/{path:.*}"})
    @ApiOperation(value="Delete document from user's private space")
    @ApiResponses(value={@ApiResponse(code=200, message="Document successfully deleted")})
    public void removeDocument(@RequestHeader String user, @RequestHeader String password, @RequestHeader(defaultValue="DEFAULT") String storageId, @PathVariable String path) {
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(user), ReadKeyPasswordHelper.getForString((String)password));
        RemoveRequest request = RemoveRequest.forPrivate((Object)userIDAuth, (StorageIdentifier)new StorageIdentifier(storageId), (String)path);
        this.datasafeService.privateService().remove(request);
        log.debug("User: {}, delete private file: {}", (Object)user, (Object)path);
    }

    @Generated
    public DocumentController(DefaultDatasafeServices datasafeService) {
        this.datasafeService = datasafeService;
    }
}

