/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.rest.impl.config;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.adorsys.datasafe.business.impl.service.DaggerDefaultDatasafeServices;
import de.adorsys.datasafe.business.impl.service.DaggerVersionedDatasafeServices;
import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import de.adorsys.datasafe.business.impl.service.VersionedDatasafeServices;
import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.impl.profile.config.DFSConfigWithStorageCreds;
import de.adorsys.datasafe.directory.impl.profile.config.DefaultDFSConfig;
import de.adorsys.datasafe.directory.impl.profile.config.MultiDFSConfig;
import de.adorsys.datasafe.directory.impl.profile.dfs.BucketAccessServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.rest.impl.config.BasicS3Factory;
import de.adorsys.datasafe.rest.impl.config.DatasafeConfig;
import de.adorsys.datasafe.rest.impl.config.DatasafeProperties;
import de.adorsys.datasafe.rest.impl.config.S3Factory;
import de.adorsys.datasafe.storage.api.RegexDelegatingStorage;
import de.adorsys.datasafe.storage.api.SchemeDelegatingStorage;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.storage.api.UriBasedAuthStorageService;
import de.adorsys.datasafe.storage.impl.db.DatabaseConnectionRegistry;
import de.adorsys.datasafe.storage.impl.db.DatabaseCredentials;
import de.adorsys.datasafe.storage.impl.db.DatabaseStorageService;
import de.adorsys.datasafe.storage.impl.fs.FileSystemStorageService;
import de.adorsys.datasafe.storage.impl.s3.BucketNameRemovingRouter;
import de.adorsys.datasafe.storage.impl.s3.BucketRouter;
import de.adorsys.datasafe.storage.impl.s3.S3StorageService;
import de.adorsys.datasafe.types.api.context.BaseOverridesRegistry;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.types.ReadStorePassword;
import de.adorsys.datasafe.types.api.utils.ExecutorServiceUtil;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
public class DatasafeConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DatasafeConfig.class);
    public static final String FILESYSTEM_ENV = "USE_FILESYSTEM";
    public static final String CLIENT_CREDENTIALS = "ALLOW_CLIENT_S3_CREDENTIALS";
    public static final String DATASAFE_S3_STORAGE = "DATASAFE_S3_STORAGE";
    private static final Set<String> ALLOWED_TABLES = ImmutableSet.of((Object)"private_profiles", (Object)"public_profiles");

    @Bean
    @ConditionalOnProperty(name={"DATASAFE_S3_STORAGE"}, havingValue="true")
    DFSConfig singleDfsConfigS3(DatasafeProperties properties) {
        return new DefaultDFSConfig(properties.getSystemRoot(), new ReadStorePassword(properties.getKeystorePassword()));
    }

    @Bean
    @ConditionalOnProperty(value={"USE_FILESYSTEM"})
    DFSConfig singleDfsConfigFilesystem(DatasafeProperties properties) {
        return new DefaultDFSConfig(properties.getSystemRoot(), new ReadStorePassword(properties.getKeystorePassword()));
    }

    @Bean
    @ConditionalOnProperty(name={"ALLOW_CLIENT_S3_CREDENTIALS"}, havingValue="true")
    DFSConfig withClientCredentials(DatasafeProperties properties) {
        return new DFSConfigWithStorageCreds(properties.getSystemRoot(), new ReadStorePassword(properties.getKeystorePassword()));
    }

    @Bean
    @ConditionalOnProperty(name={"ALLOW_CLIENT_S3_CREDENTIALS"}, havingValue="true")
    OverridesRegistry withClientCredentialsOverrides() {
        BaseOverridesRegistry registry = new BaseOverridesRegistry();
        BucketAccessServiceImplRuntimeDelegatable.overrideWith((OverridesRegistry)registry, args -> new WithAccessCredentials(args.getStorageKeyStoreOperations(), null));
        return registry;
    }

    @Bean
    @ConditionalOnMissingBean(value={DFSConfig.class})
    DFSConfig multiDfsConfig(DatasafeProperties properties) {
        return new MultiDFSConfig(URI.create(properties.getSystemRoot()), URI.create(properties.getDbUrl()), new ReadStorePassword(properties.getKeystorePassword()));
    }

    @Bean
    DefaultDatasafeServices datasafeService(StorageService storageService, DFSConfig dfsConfig, Optional<OverridesRegistry> registry, DatasafeProperties properties) {
        return DaggerDefaultDatasafeServices.builder().config(dfsConfig).storage(storageService).overridesRegistry((OverridesRegistry)registry.orElse(null)).encryption(properties.getEncryption().toEncryptionConfig()).build();
    }

    @Bean
    VersionedDatasafeServices versionedDatasafeServices(StorageService storageService, DFSConfig dfsConfig, Optional<OverridesRegistry> registry, DatasafeProperties properties) {
        return DaggerVersionedDatasafeServices.builder().config(dfsConfig).storage(storageService).overridesRegistry((OverridesRegistry)registry.orElse(null)).encryption(properties.getEncryption().toEncryptionConfig()).build();
    }

    @Bean
    @ConditionalOnProperty(value={"ALLOW_CLIENT_S3_CREDENTIALS"}, havingValue="true")
    StorageService clientCredentials(AmazonS3 s3, S3Factory factory, DatasafeProperties properties) {
        ExecutorService executorService = ExecutorServiceUtil.submitterExecutesOnStarvationExecutingService();
        S3StorageService basicStorage = new S3StorageService(s3, properties.getBucketName(), executorService);
        return new RegexDelegatingStorage((Map)ImmutableMap.builder().put((Object)Pattern.compile(properties.getSystemRoot() + ".+"), (Object)basicStorage).put((Object)Pattern.compile(".+"), (Object)new UriBasedAuthStorageService(acc -> new S3StorageService(factory.getClient(acc.getEndpoint(), acc.getRegion(), acc.getAccessKey(), acc.getSecretKey()), (BucketRouter)new BucketNameRemovingRouter(acc.getBucketName()), executorService))).build());
    }

    @Bean
    S3Factory factory() {
        return new BasicS3Factory();
    }

    @Bean
    @ConditionalOnProperty(value={"USE_FILESYSTEM"})
    StorageService singleStorageServiceFilesystem(DatasafeProperties properties) {
        String root = System.getenv(FILESYSTEM_ENV);
        log.info("==================== FILESYSTEM");
        log.info("build DFS to FILESYSTEM with root " + root);
        properties.setSystemRoot(root);
        return new FileSystemStorageService(Paths.get(root, new String[0]));
    }

    @Bean
    @ConditionalOnProperty(name={"DATASAFE_S3_STORAGE"}, havingValue="true")
    StorageService singleStorageServiceS3(AmazonS3 s3, DatasafeProperties properties) {
        return new S3StorageService(s3, properties.getBucketName(), ExecutorServiceUtil.submitterExecutesOnStarvationExecutingService());
    }

    @Bean
    @ConditionalOnMissingBean(value={StorageService.class})
    StorageService multiStorageService(DatasafeProperties properties) {
        DatabaseStorageService db = new DatabaseStorageService(ALLOWED_TABLES, new DatabaseConnectionRegistry((Map)ImmutableMap.of((Object)properties.getDbUrl(), (Object)new DatabaseCredentials(properties.getDbUsername(), properties.getDbPassword()))));
        S3StorageService s3StorageService = new S3StorageService(this.s3(properties), properties.getBucketName(), ExecutorServiceUtil.submitterExecutesOnStarvationExecutingService());
        return new SchemeDelegatingStorage((Map)ImmutableMap.of((Object)"s3", (Object)s3StorageService, (Object)"jdbc-mysql", (Object)db));
    }

    @Bean
    @Lazy
    AmazonS3 s3(DatasafeProperties properties) {
        boolean useEndpoint = properties.getAmazonUrl() != null;
        AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(properties.getAmazonAccessKeyID(), properties.getAmazonSecretAccessKey()));
        AmazonS3ClientBuilder builder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentialsProvider);
        if (useEndpoint) {
            builder = (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(properties.getAmazonUrl(), properties.getAmazonRegion()))).enablePathStyleAccess();
        } else {
            builder.withRegion(properties.getAmazonRegion());
        }
        AmazonS3 amazonS3 = (AmazonS3)builder.build();
        if (useEndpoint && !amazonS3.doesBucketExistV2(properties.getBucketName())) {
            amazonS3.createBucket(properties.getBucketName());
        }
        return amazonS3;
    }
}

