/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.rest.impl.dto;

import de.adorsys.datasafe.directory.api.types.UserPrivateProfile;
import de.adorsys.datasafe.rest.impl.dto.Util;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.StorageIdentifier;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public class UserPrivateProfileDTO {
    @NotBlank
    private String keystore;
    @NotEmpty
    private Map<String, String> privateStorage;
    @NotBlank
    private String inboxWithFullAccess;
    @NotBlank
    private String publishPublicKeysTo;
    @NotNull
    private List<String> associatedResources;
    private String documentVersionStorage;
    private String storageCredentialsKeystore;

    public static UserPrivateProfileDTO from(UserPrivateProfile privateProfile) {
        return new UserPrivateProfileDTO(Util.str((AbsoluteLocation)privateProfile.getKeystore()), privateProfile.getPrivateStorage().entrySet().stream().collect(Collectors.toMap(it -> ((StorageIdentifier)it.getKey()).getId(), it -> Util.str((AbsoluteLocation)((AbsoluteLocation)it.getValue())))), Util.str((AbsoluteLocation)privateProfile.getInboxWithFullAccess()), Util.str((AbsoluteLocation)privateProfile.getPublishPublicKeysTo()), privateProfile.getAssociatedResources().stream().map(Util::str).collect(Collectors.toList()), Util.str((AbsoluteLocation)privateProfile.getDocumentVersionStorage()), Util.str((AbsoluteLocation)privateProfile.getStorageCredentialsKeystore()));
    }

    public UserPrivateProfile toProfile() {
        return UserPrivateProfile.builder().publishPublicKeysTo(Util.publicResource((String)this.publishPublicKeysTo)).storageCredentialsKeystore(Util.privateResource((String)this.storageCredentialsKeystore)).associatedResources(this.associatedResources.stream().map(Util::privateResource).collect(Collectors.toList())).documentVersionStorage(Util.privateResource((String)this.documentVersionStorage)).inboxWithFullAccess(Util.privateResource((String)this.inboxWithFullAccess)).keystore(Util.privateResource((String)this.keystore)).privateStorage(this.privateStorage.entrySet().stream().collect(Collectors.toMap(it -> new StorageIdentifier((String)it.getKey()), it -> Util.privateResource((String)((String)it.getValue()))))).build();
    }

    @Generated
    public String getKeystore() {
        return this.keystore;
    }

    @Generated
    public Map<String, String> getPrivateStorage() {
        return this.privateStorage;
    }

    @Generated
    public String getInboxWithFullAccess() {
        return this.inboxWithFullAccess;
    }

    @Generated
    public String getPublishPublicKeysTo() {
        return this.publishPublicKeysTo;
    }

    @Generated
    public List<String> getAssociatedResources() {
        return this.associatedResources;
    }

    @Generated
    public String getDocumentVersionStorage() {
        return this.documentVersionStorage;
    }

    @Generated
    public String getStorageCredentialsKeystore() {
        return this.storageCredentialsKeystore;
    }

    @Generated
    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    @Generated
    public void setPrivateStorage(Map<String, String> privateStorage) {
        this.privateStorage = privateStorage;
    }

    @Generated
    public void setInboxWithFullAccess(String inboxWithFullAccess) {
        this.inboxWithFullAccess = inboxWithFullAccess;
    }

    @Generated
    public void setPublishPublicKeysTo(String publishPublicKeysTo) {
        this.publishPublicKeysTo = publishPublicKeysTo;
    }

    @Generated
    public void setAssociatedResources(List<String> associatedResources) {
        this.associatedResources = associatedResources;
    }

    @Generated
    public void setDocumentVersionStorage(String documentVersionStorage) {
        this.documentVersionStorage = documentVersionStorage;
    }

    @Generated
    public void setStorageCredentialsKeystore(String storageCredentialsKeystore) {
        this.storageCredentialsKeystore = storageCredentialsKeystore;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserPrivateProfileDTO)) {
            return false;
        }
        UserPrivateProfileDTO other = (UserPrivateProfileDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$keystore = this.getKeystore();
        String other$keystore = other.getKeystore();
        if (this$keystore == null ? other$keystore != null : !this$keystore.equals(other$keystore)) {
            return false;
        }
        Map this$privateStorage = this.getPrivateStorage();
        Map other$privateStorage = other.getPrivateStorage();
        if (this$privateStorage == null ? other$privateStorage != null : !((Object)this$privateStorage).equals(other$privateStorage)) {
            return false;
        }
        String this$inboxWithFullAccess = this.getInboxWithFullAccess();
        String other$inboxWithFullAccess = other.getInboxWithFullAccess();
        if (this$inboxWithFullAccess == null ? other$inboxWithFullAccess != null : !this$inboxWithFullAccess.equals(other$inboxWithFullAccess)) {
            return false;
        }
        String this$publishPublicKeysTo = this.getPublishPublicKeysTo();
        String other$publishPublicKeysTo = other.getPublishPublicKeysTo();
        if (this$publishPublicKeysTo == null ? other$publishPublicKeysTo != null : !this$publishPublicKeysTo.equals(other$publishPublicKeysTo)) {
            return false;
        }
        List this$associatedResources = this.getAssociatedResources();
        List other$associatedResources = other.getAssociatedResources();
        if (this$associatedResources == null ? other$associatedResources != null : !((Object)this$associatedResources).equals(other$associatedResources)) {
            return false;
        }
        String this$documentVersionStorage = this.getDocumentVersionStorage();
        String other$documentVersionStorage = other.getDocumentVersionStorage();
        if (this$documentVersionStorage == null ? other$documentVersionStorage != null : !this$documentVersionStorage.equals(other$documentVersionStorage)) {
            return false;
        }
        String this$storageCredentialsKeystore = this.getStorageCredentialsKeystore();
        String other$storageCredentialsKeystore = other.getStorageCredentialsKeystore();
        return !(this$storageCredentialsKeystore == null ? other$storageCredentialsKeystore != null : !this$storageCredentialsKeystore.equals(other$storageCredentialsKeystore));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UserPrivateProfileDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $keystore = this.getKeystore();
        result = result * 59 + ($keystore == null ? 43 : $keystore.hashCode());
        Map $privateStorage = this.getPrivateStorage();
        result = result * 59 + ($privateStorage == null ? 43 : ((Object)$privateStorage).hashCode());
        String $inboxWithFullAccess = this.getInboxWithFullAccess();
        result = result * 59 + ($inboxWithFullAccess == null ? 43 : $inboxWithFullAccess.hashCode());
        String $publishPublicKeysTo = this.getPublishPublicKeysTo();
        result = result * 59 + ($publishPublicKeysTo == null ? 43 : $publishPublicKeysTo.hashCode());
        List $associatedResources = this.getAssociatedResources();
        result = result * 59 + ($associatedResources == null ? 43 : ((Object)$associatedResources).hashCode());
        String $documentVersionStorage = this.getDocumentVersionStorage();
        result = result * 59 + ($documentVersionStorage == null ? 43 : $documentVersionStorage.hashCode());
        String $storageCredentialsKeystore = this.getStorageCredentialsKeystore();
        result = result * 59 + ($storageCredentialsKeystore == null ? 43 : $storageCredentialsKeystore.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UserPrivateProfileDTO(keystore=" + this.getKeystore() + ", privateStorage=" + this.getPrivateStorage() + ", inboxWithFullAccess=" + this.getInboxWithFullAccess() + ", publishPublicKeysTo=" + this.getPublishPublicKeysTo() + ", associatedResources=" + this.getAssociatedResources() + ", documentVersionStorage=" + this.getDocumentVersionStorage() + ", storageCredentialsKeystore=" + this.getStorageCredentialsKeystore() + ")";
    }

    @Generated
    public UserPrivateProfileDTO() {
    }

    @Generated
    public UserPrivateProfileDTO(String keystore, Map<String, String> privateStorage, String inboxWithFullAccess, String publishPublicKeysTo, List<String> associatedResources, String documentVersionStorage, String storageCredentialsKeystore) {
        this.keystore = keystore;
        this.privateStorage = privateStorage;
        this.inboxWithFullAccess = inboxWithFullAccess;
        this.publishPublicKeysTo = publishPublicKeysTo;
        this.associatedResources = associatedResources;
        this.documentVersionStorage = documentVersionStorage;
        this.storageCredentialsKeystore = storageCredentialsKeystore;
    }
}

