/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.rest.impl.controller;

import com.amazonaws.services.s3.model.AmazonS3Exception;
import de.adorsys.datasafe.rest.impl.controller.AuthenticateController;
import de.adorsys.datasafe.rest.impl.controller.DocumentController;
import de.adorsys.datasafe.rest.impl.controller.InboxController;
import de.adorsys.datasafe.rest.impl.controller.UserController;
import de.adorsys.datasafe.rest.impl.controller.VersionController;
import de.adorsys.datasafe.rest.impl.exceptions.UnauthorizedException;
import de.adorsys.datasafe.rest.impl.exceptions.UserDoesNotExistsException;
import de.adorsys.datasafe.rest.impl.exceptions.UserExistsException;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.crypto.BadPaddingException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice(basePackageClasses={DocumentController.class, InboxController.class, UserController.class, VersionController.class, AuthenticateController.class})
public class GenericControllerAdvice {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenericControllerAdvice.class);

    @ExceptionHandler(value={UserDoesNotExistsException.class})
    public ResponseEntity<List<String>> handleUserDoesNotExistsException(UserDoesNotExistsException ex) {
        log.debug("User does not exists exception: {}", (Object)ex.getMessage(), (Object)ex);
        List<String> errors = Collections.singletonList(ex.getMessage());
        return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(new ArrayList<String>(errors));
    }

    @ExceptionHandler(value={UserExistsException.class})
    public ResponseEntity<List<String>> handleUserExistsException(UserExistsException ex) {
        log.debug("User already exists exception: {}", (Object)ex.getMessage(), (Object)ex);
        List<String> errors = Collections.singletonList(ex.getMessage());
        return ResponseEntity.badRequest().body(new ArrayList<String>(errors));
    }

    @ExceptionHandler(value={AmazonS3Exception.class})
    public ResponseEntity<List<String>> handleFileNotFoundException(Exception ex) {
        log.debug("File not found exception: {}", (Object)ex.getMessage(), (Object)ex);
        List<String> errors = Collections.singletonList("File not found");
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(new ArrayList<String>(errors));
    }

    @ExceptionHandler(value={UnauthorizedException.class, BadCredentialsException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED, reason="Access Denied")
    public ResponseEntity<List<String>> handleUnauthorizedException(Exception ex) {
        log.debug("Unauthorized exception: {}", (Object)ex.getMessage(), (Object)ex);
        List<String> errors = Collections.singletonList(ex.getMessage());
        return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).body(new ArrayList<String>(errors));
    }

    @ExceptionHandler(value={UnrecoverableKeyException.class, BadPaddingException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN, reason="Access Denied")
    public ResponseEntity<List<String>> handleBadCredentialsException(Exception ex) {
        log.debug("Bad credentials exception: {}", (Object)ex.getMessage(), (Object)ex);
        List<String> errors = Collections.singletonList(ex.getMessage());
        return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body(new ArrayList<String>(errors));
    }

    @ExceptionHandler(value={RuntimeException.class})
    public ResponseEntity<List<String>> handleException(Exception ex) {
        log.debug("Unhandled exception: {}", (Object)ex.getMessage(), (Object)ex);
        List<String> errors = Collections.singletonList(ex.getMessage());
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(new ArrayList<String>(errors));
    }
}

