/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.rest.impl.controller;

import com.amazonaws.services.s3.model.AmazonS3Exception;
import de.adorsys.datasafe.business.impl.service.VersionedDatasafeServices;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadKeyPassword;
import de.adorsys.datasafe.rest.impl.exceptions.UnauthorizedException;
import de.adorsys.datasafe.types.api.actions.ListRequest;
import de.adorsys.datasafe.types.api.actions.ReadRequest;
import de.adorsys.datasafe.types.api.actions.RemoveRequest;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(description="Operations on private documents with enabled versioning")
public class VersionController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VersionController.class);
    private final VersionedDatasafeServices versionedDatasafeServices;

    @GetMapping(value={"/versioned/{path:.*}"}, produces={"application/json"})
    @ApiOperation(value="List latest documents in user's private space")
    @ApiResponses(value={@ApiResponse(code=200, message="List command successfully completed"), @ApiResponse(code=401, message="Unauthorised")})
    public List<String> listVersionedDocuments(@RequestHeader String user, @RequestHeader String password, @PathVariable(required=false) String path) {
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(user), new ReadKeyPassword(password));
        path = Optional.ofNullable(path).orElse("./");
        try {
            List<String> documentList = this.versionedDatasafeServices.latestPrivate().listWithDetails(ListRequest.forDefaultPrivate((Object)userIDAuth, (String)path)).map(e -> ((PrivateResource)((AbsoluteLocation)e.absolute()).getResource()).decryptedPath().asString()).collect(Collectors.toList());
            log.debug("List for path {} returned {} items", (Object)path, (Object)documentList.size());
            return documentList;
        }
        catch (AmazonS3Exception e2) {
            throw new UnauthorizedException("Unauthorized", (Throwable)e2);
        }
    }

    @GetMapping(value={"/versioned/{path:.*}"}, produces={"application/octet-stream"})
    @ApiOperation(value="Read latest document from user's private space")
    @ApiResponses(value={@ApiResponse(code=200, message="Document was successfully read"), @ApiResponse(code=404, message="Document not found")})
    public void readVersionedDocument(@RequestHeader String user, @RequestHeader String password, @PathVariable String path, HttpServletResponse response) {
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(user), new ReadKeyPassword(password));
        PrivateResource resource = BasePrivateResource.forPrivate((String)path);
        ReadRequest request = ReadRequest.forPrivate((Object)userIDAuth, (PrivateResource)resource);
        response.addHeader("Content-Type", "application/octet-stream");
        try (InputStream is = this.versionedDatasafeServices.latestPrivate().read(request);
             ServletOutputStream os = response.getOutputStream();){
            StreamUtils.copy((InputStream)is, (OutputStream)os);
        }
        log.debug("User: {}, read private file from: {}", (Object)user, (Object)resource);
    }

    @PutMapping(value={"/versioned/{path:.*}"}, consumes={"multipart/form-data"})
    @ApiOperation(value="Write latest document to user's private space")
    @ApiResponses(value={@ApiResponse(code=200, message="Document was successfully written")})
    public void writeVersionedDocument(@RequestHeader String user, @RequestHeader String password, @PathVariable String path, @RequestParam(value="file") MultipartFile file) {
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(user), new ReadKeyPassword(password));
        WriteRequest request = WriteRequest.forDefaultPrivate((Object)userIDAuth, (String)path);
        try (OutputStream os = this.versionedDatasafeServices.latestPrivate().write(request);
             InputStream is = file.getInputStream();){
            StreamUtils.copy((InputStream)is, (OutputStream)os);
        }
        log.debug("User: {}, write private file to: {}", (Object)user, (Object)path);
    }

    @DeleteMapping(value={"/versioned/{path:.*}"})
    @ApiOperation(value="Delete latest document from user's private space")
    @ApiResponses(value={@ApiResponse(code=200, message="Document successfully deleted")})
    public void deleteVersionedDocument(@RequestHeader String user, @RequestHeader String password, @PathVariable String path) {
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(user), new ReadKeyPassword(password));
        PrivateResource resource = BasePrivateResource.forPrivate((String)path);
        RemoveRequest request = RemoveRequest.forPrivate((Object)userIDAuth, (PrivateResource)resource);
        this.versionedDatasafeServices.latestPrivate().remove(request);
        log.debug("User: {}, delete private file: {}", (Object)user, (Object)resource);
    }

    @GetMapping(value={"/versions/list/{path:.*}"}, produces={"application/json"})
    @ApiOperation(value="List versions of document")
    @ApiResponses(value={@ApiResponse(code=200, message="List command successfully completed"), @ApiResponse(code=401, message="Unauthorised")})
    public List<String> versionsOf(@RequestHeader String user, @RequestHeader String password, @ApiParam(defaultValue=".") @PathVariable(required=false) String path) {
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(user), new ReadKeyPassword(password));
        path = Optional.ofNullable(path).map(it -> it.replaceAll("^\\.$", "")).orElse("./");
        PrivateResource resource = BasePrivateResource.forPrivate((String)path);
        ListRequest request = ListRequest.builder().location((ResourceLocation)resource).owner((Object)userIDAuth).build();
        List versionList = this.versionedDatasafeServices.versionInfo().versionsOf(request).collect(Collectors.toList());
        log.debug("Versions for path {} returned {} items", (Object)path, (Object)versionList.size());
        return versionList.stream().map(a -> ((ResolvedResource)((AbsoluteLocation)a.absolute()).getResource()).asPrivate().decryptedPath().asString()).collect(Collectors.toList());
    }

    @Generated
    public VersionController(VersionedDatasafeServices versionedDatasafeServices) {
        this.versionedDatasafeServices = versionedDatasafeServices;
    }
}

