/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.rest.impl.controller;

import de.adorsys.datasafe.business.impl.service.VersionedDatasafeServices;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadKeyPassword;
import de.adorsys.datasafe.rest.impl.dto.NewPasswordDTO;
import de.adorsys.datasafe.rest.impl.dto.UserDTO;
import de.adorsys.datasafe.rest.impl.exceptions.UserDoesNotExistsException;
import de.adorsys.datasafe.rest.impl.exceptions.UserExistsException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import lombok.Generated;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user"}, produces={"application/json"})
@Api(description="Create and delete users")
public class UserController {
    private final VersionedDatasafeServices dataSafeService;

    @PutMapping
    @ApiOperation(value="Creates new user")
    @ApiResponses(value={@ApiResponse(code=200, message="User successfully created"), @ApiResponse(code=400, message="User already exists")})
    public void createUser(@Validated @RequestBody UserDTO userDTO) {
        ReadKeyPassword readKeyPassword = new ReadKeyPassword(userDTO.getPassword());
        UserIDAuth auth = new UserIDAuth(new UserID(userDTO.getUserName()), readKeyPassword);
        if (this.dataSafeService.userProfile().userExists(auth.getUserID())) {
            throw new UserExistsException("user '" + auth.getUserID().getValue() + "' already exists");
        }
        this.dataSafeService.userProfile().registerUsingDefaults(auth);
    }

    @PostMapping(value={"/password"})
    @ApiOperation(value="Change users' password")
    public void changePassword(@RequestHeader String user, @RequestHeader String password, @Validated @RequestBody NewPasswordDTO newPassword) {
        ReadKeyPassword readKeyPassword = new ReadKeyPassword(password);
        UserIDAuth auth = new UserIDAuth(new UserID(user), readKeyPassword);
        this.dataSafeService.userProfile().updateReadKeyPassword(auth, new ReadKeyPassword(newPassword.getNewPassword()));
    }

    @DeleteMapping
    @ApiOperation(value="Deletes existing user")
    @ApiResponses(value={@ApiResponse(code=200, message="User successfully deleted"), @ApiResponse(code=404, message="User does not exist")})
    public void deleteUser(@RequestHeader String user, @RequestHeader String password) {
        UserIDAuth auth = new UserIDAuth(new UserID(user), new ReadKeyPassword(password));
        if (!this.dataSafeService.userProfile().userExists(auth.getUserID())) {
            throw new UserDoesNotExistsException("user '" + auth.getUserID().getValue() + "' does not exists");
        }
        this.dataSafeService.userProfile().deregister(auth);
    }

    @Generated
    public UserController(VersionedDatasafeServices dataSafeService) {
        this.dataSafeService = dataSafeService;
    }
}

