/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.rest.impl.config;

import de.adorsys.datasafe.rest.impl.config.DatasafeProperties;
import de.adorsys.datasafe.rest.impl.config.MvcConfig;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.DefaultServletHandlerConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
public class MvcConfig
extends WebMvcConfigurationSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MvcConfig.class);
    private final DatasafeProperties datasafeProperties;

    @Bean
    public RequestMappingHandlerMapping requestMappingHandlerMapping() {
        RequestMappingHandlerMapping handlerMapping = super.requestMappingHandlerMapping();
        handlerMapping.setPathMatcher((PathMatcher)new ExtendedMatcher());
        return handlerMapping;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        if (StringUtils.isEmpty((Object)this.datasafeProperties.getStaticResources())) {
            return;
        }
        log.info("Serving static resources from {} as /static/**", (Object)this.datasafeProperties.getStaticResources());
        registry.addResourceHandler(new String[]{"/static/**"}).addResourceLocations(new String[]{this.datasafeProperties.getStaticResources()});
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.favorPathExtension(false).favorParameter(false).ignoreAcceptHeader(false).defaultContentType(new MediaType[]{MediaType.APPLICATION_JSON});
    }

    protected void configureDefaultServletHandling(DefaultServletHandlerConfigurer configurer) {
        configurer.enable();
    }

    @Generated
    public MvcConfig(DatasafeProperties datasafeProperties) {
        this.datasafeProperties = datasafeProperties;
    }
}

