/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.rest.impl.config;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.adorsys.datasafe.business.impl.service.DaggerDefaultDatasafeServices;
import de.adorsys.datasafe.business.impl.service.DaggerVersionedDatasafeServices;
import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import de.adorsys.datasafe.business.impl.service.VersionedDatasafeServices;
import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.impl.profile.config.DefaultDFSConfig;
import de.adorsys.datasafe.directory.impl.profile.config.MultiDFSConfig;
import de.adorsys.datasafe.rest.impl.config.DatasafeProperties;
import de.adorsys.datasafe.storage.api.SchemeDelegatingStorage;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.storage.impl.db.DatabaseConnectionRegistry;
import de.adorsys.datasafe.storage.impl.db.DatabaseCredentials;
import de.adorsys.datasafe.storage.impl.db.DatabaseStorageService;
import de.adorsys.datasafe.storage.impl.fs.FileSystemStorageService;
import de.adorsys.datasafe.storage.impl.s3.S3StorageService;
import java.net.URI;
import java.nio.file.Paths;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import lombok.Generated;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DatasafeConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DatasafeConfig.class);
    public static final String FILESYSTEM_ENV = "USE_FILESYSTEM";
    private static final Set<String> ALLOWED_TABLES = ImmutableSet.of((Object)"private_profiles", (Object)"public_profiles");
    private DatasafeProperties datasafeProperties;

    @Inject
    DatasafeConfig(DatasafeProperties datasafeProperties) {
        this.datasafeProperties = datasafeProperties;
    }

    @Bean
    @ConditionalOnProperty(name={"DATASAFE_SINGLE_STORAGE"}, havingValue="true")
    DFSConfig singleDfsConfig(DatasafeProperties properties) {
        return new DefaultDFSConfig(properties.getSystemRoot(), properties.getKeystorePassword());
    }

    @Bean
    @ConditionalOnMissingBean(value={DFSConfig.class})
    DFSConfig multiDfsConfig(DatasafeProperties properties) {
        return new MultiDFSConfig(URI.create(properties.getS3Path()), URI.create(properties.getDbProfilePath()), properties.getKeystorePassword());
    }

    @Bean
    DefaultDatasafeServices datasafeService(StorageService storageService, DFSConfig dfsConfig) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        return DaggerDefaultDatasafeServices.builder().config(dfsConfig).storage(storageService).build();
    }

    @Bean
    VersionedDatasafeServices versionedDatasafeServices(StorageService storageService, DFSConfig dfsConfig) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        return DaggerVersionedDatasafeServices.builder().config(dfsConfig).storage(storageService).build();
    }

    @Bean
    @ConditionalOnProperty(value={"USE_FILESYSTEM"})
    StorageService fsStorageService(DatasafeProperties properties) {
        String root = System.getenv(FILESYSTEM_ENV);
        log.info("==================== FILESYSTEM");
        log.info("build DFS to FILESYSTEM with root " + root);
        properties.setSystemRoot(root);
        return new FileSystemStorageService(Paths.get(root, new String[0]));
    }

    @Bean
    @ConditionalOnProperty(name={"DATASAFE_SINGLE_STORAGE"}, havingValue="true")
    StorageService singleStorageService(AmazonS3 s3, DatasafeProperties properties) {
        return new S3StorageService(s3, properties.getBucketName(), Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()));
    }

    @Bean
    @ConditionalOnMissingBean(value={StorageService.class})
    StorageService multiStorageService(DatasafeProperties properties) {
        DatabaseStorageService db = new DatabaseStorageService(ALLOWED_TABLES, new DatabaseConnectionRegistry((Map)ImmutableMap.of((Object)properties.getDbUrl(), (Object)new DatabaseCredentials(properties.getDbUsername(), properties.getDbPassword()))));
        S3StorageService s3StorageService = new S3StorageService(this.s3(properties), properties.getBucketName(), Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()));
        SchemeDelegatingStorage multiDfs = new SchemeDelegatingStorage((Map)ImmutableMap.of((Object)"s3", (Object)s3StorageService, (Object)"jdbc-mysql", (Object)db));
        return multiDfs;
    }

    @Bean
    AmazonS3 s3(DatasafeProperties properties) {
        boolean useEndpoint = properties.getAmazonUrl() != null;
        AWSStaticCredentialsProvider credentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(properties.getAmazonAccessKeyID(), properties.getAmazonSecretAccessKey()));
        AmazonS3ClientBuilder builder = (AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentialsProvider);
        if (useEndpoint) {
            builder = (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(properties.getAmazonUrl(), properties.getAmazonRegion()))).enablePathStyleAccess();
        } else {
            builder.withRegion(properties.getAmazonRegion());
        }
        AmazonS3 amazonS3 = (AmazonS3)builder.build();
        if (useEndpoint && !amazonS3.doesBucketExistV2(properties.getBucketName())) {
            amazonS3.createBucket(properties.getBucketName());
        }
        return amazonS3;
    }
}

