/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.rest.impl.controller;

import de.adorsys.datasafe.business.impl.service.VersionedDatasafeServices;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadKeyPassword;
import de.adorsys.datasafe.types.api.actions.ListRequest;
import de.adorsys.datasafe.types.api.actions.ReadRequest;
import de.adorsys.datasafe.types.api.actions.RemoveRequest;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class VersionController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VersionController.class);
    private final VersionedDatasafeServices versionedDatasafeServices;

    @GetMapping(value={"/versioned/{path:.*}"}, produces={"application/json"})
    public List<String> listVersionedDocuments(@RequestHeader String user, @RequestHeader String password, @PathVariable(required=false) String path) {
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(user), new ReadKeyPassword(password));
        path = Optional.ofNullable(path).orElse("./");
        List<String> documentList = this.versionedDatasafeServices.latestPrivate().listWithDetails(ListRequest.forDefaultPrivate((Object)userIDAuth, (String)path)).map(e -> ((PrivateResource)((AbsoluteLocation)e.absolute()).getResource()).decryptedPath().getPath()).collect(Collectors.toList());
        log.debug("List for path {} returned {} items", (Object)path, (Object)documentList.size());
        return documentList;
    }

    @GetMapping(value={"/versioned/{path:.*}"}, produces={"application/octet-stream"})
    public void readVersionedDocument(@RequestHeader String user, @RequestHeader String password, @PathVariable String path, HttpServletResponse response) {
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(user), new ReadKeyPassword(password));
        PrivateResource resource = BasePrivateResource.forPrivate((String)path);
        ReadRequest request = ReadRequest.forPrivate((Object)userIDAuth, (PrivateResource)resource);
        try (InputStream is = this.versionedDatasafeServices.latestPrivate().read(request);
             ServletOutputStream os = response.getOutputStream();){
            StreamUtils.copy((InputStream)is, (OutputStream)os);
        }
        log.debug("User: {}, read private file from: {}", (Object)user, (Object)resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PutMapping(value={"/versioned/{path:.*}"}, consumes={"application/octet-stream"})
    public void writeVersionedDocument(@RequestHeader String user, @RequestHeader String password, @PathVariable String path, InputStream is) {
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(user), new ReadKeyPassword(password));
        WriteRequest request = WriteRequest.forDefaultPrivate((Object)userIDAuth, (String)path);
        try (OutputStream os = this.versionedDatasafeServices.latestPrivate().write(request);){
            StreamUtils.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            is.close();
        }
        log.debug("User: {}, write private file to: {}", (Object)user, (Object)path);
    }

    @DeleteMapping(value={"/versioned/{path:.*}"})
    public void deleteVersionedDocument(@RequestHeader String user, @RequestHeader String password, @PathVariable String path) {
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(user), new ReadKeyPassword(password));
        PrivateResource resource = BasePrivateResource.forPrivate((String)path);
        RemoveRequest request = RemoveRequest.forPrivate((Object)userIDAuth, (PrivateResource)resource);
        this.versionedDatasafeServices.latestPrivate().remove(request);
        log.debug("User: {}, delete private file: {}", (Object)user, (Object)resource);
    }

    @GetMapping(value={"/versions/list/{path:.*}"}, produces={"application/json"})
    public List<String> versionsOf(@RequestHeader String user, @RequestHeader String password, @PathVariable(required=false) String path) {
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(user), new ReadKeyPassword(password));
        path = Optional.ofNullable(path).orElse("./");
        PrivateResource resource = BasePrivateResource.forPrivate((String)path);
        ListRequest request = ListRequest.builder().location((ResourceLocation)resource).owner((Object)userIDAuth).build();
        List versionList = this.versionedDatasafeServices.versionInfo().versionsOf(request).collect(Collectors.toList());
        log.debug("Versions for path {} returned {} items", (Object)path, (Object)versionList.size());
        return versionList.stream().map(a -> ((ResolvedResource)((AbsoluteLocation)a.absolute()).getResource()).asPrivate().decryptedPath().toASCIIString()).collect(Collectors.toList());
    }

    @Generated
    public VersionController(VersionedDatasafeServices versionedDatasafeServices) {
        this.versionedDatasafeServices = versionedDatasafeServices;
    }
}

