/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.rest.impl.controller;

import de.adorsys.datasafe.business.impl.service.VersionedDatasafeServices;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadKeyPassword;
import de.adorsys.datasafe.rest.impl.dto.UserDTO;
import io.swagger.annotations.ApiOperation;
import lombok.Generated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user"}, produces={"application/json"}, consumes={"application/json"})
public class UserController {
    private final VersionedDatasafeServices dataSafeService;

    @PutMapping
    @ApiOperation(value="Create user")
    public void createUser(@RequestBody UserDTO requestDTO) {
        ReadKeyPassword readKeyPassword = new ReadKeyPassword(requestDTO.getPassword());
        UserIDAuth auth = new UserIDAuth(new UserID(requestDTO.getUserName()), readKeyPassword);
        this.dataSafeService.userProfile().registerUsingDefaults(auth);
    }

    @DeleteMapping
    @ApiOperation(value="Delete user")
    public void deleteUser(@RequestHeader String user, @RequestHeader String password) {
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(user), new ReadKeyPassword(password));
        this.dataSafeService.userProfile().deregister(userIDAuth);
    }

    @Generated
    public UserController(VersionedDatasafeServices dataSafeService) {
        this.dataSafeService = dataSafeService;
    }
}

