/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.rest.impl.controller;

import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadKeyPassword;
import de.adorsys.datasafe.types.api.actions.ListRequest;
import de.adorsys.datasafe.types.api.actions.ReadRequest;
import de.adorsys.datasafe.types.api.actions.RemoveRequest;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/inbox"})
public class InboxController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InboxController.class);
    private final DefaultDatasafeServices dataSafeService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PutMapping(value={"/{path:.*}"}, consumes={"application/octet-stream"})
    public void writeToInbox(@RequestHeader Set<String> users, @PathVariable String path, InputStream is) {
        Set toUsers = users.stream().map(UserID::new).collect(Collectors.toSet());
        try (OutputStream os = this.dataSafeService.inboxService().write(WriteRequest.forDefaultPublic(toUsers, (String)path));){
            StreamUtils.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            is.close();
        }
        log.debug("Users {}, write to INBOX file: {}", toUsers, (Object)path);
    }

    @GetMapping(value={"/{path:.*}"}, produces={"application/octet-stream"})
    public void readFromInbox(@RequestHeader String user, @RequestHeader String password, @PathVariable String path, HttpServletResponse response) {
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(user), new ReadKeyPassword(password));
        PrivateResource resource = BasePrivateResource.forPrivate((String)path);
        try (InputStream is = this.dataSafeService.inboxService().read(ReadRequest.forPrivate((Object)userIDAuth, (PrivateResource)resource));
             ServletOutputStream os = response.getOutputStream();){
            StreamUtils.copy((InputStream)is, (OutputStream)os);
        }
        log.debug("User {}, read from INBOX file {}", (Object)user, (Object)resource);
    }

    @DeleteMapping(value={"/{path:.*}"})
    public void deleteFromInbox(@RequestHeader String user, @RequestHeader String password, @PathVariable String path) {
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(user), new ReadKeyPassword(password));
        PrivateResource resource = BasePrivateResource.forPrivate((String)path);
        RemoveRequest request = RemoveRequest.forPrivate((Object)userIDAuth, (PrivateResource)resource);
        this.dataSafeService.inboxService().remove(request);
        log.debug("User {}, delete from INBOX file {}", (Object)user, (Object)resource);
    }

    @GetMapping(value={"/{path:.*}"}, produces={"application/json"})
    public List<String> listInbox(@RequestHeader String user, @RequestHeader String password, @PathVariable(required=false) String path) {
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(user), new ReadKeyPassword(password));
        path = Optional.ofNullable(path).orElse("./");
        List<String> inboxList = this.dataSafeService.inboxService().list(ListRequest.forDefaultPrivate((Object)userIDAuth, (String)path)).map(e -> ((ResolvedResource)e.getResource()).asPrivate().decryptedPath().getPath()).collect(Collectors.toList());
        log.debug("User's {} inbox contains {} items", (Object)user, (Object)inboxList.size());
        return inboxList;
    }

    @Generated
    public InboxController(DefaultDatasafeServices dataSafeService) {
        this.dataSafeService = dataSafeService;
    }
}

