/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.rest.impl.controller;

import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadKeyPassword;
import de.adorsys.datasafe.types.api.actions.ListRequest;
import de.adorsys.datasafe.types.api.actions.ReadRequest;
import de.adorsys.datasafe.types.api.actions.RemoveRequest;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DocumentController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocumentController.class);
    private final DefaultDatasafeServices dataSafeService;

    @GetMapping(value={"/document/{path:.*}"}, produces={"application/octet-stream"})
    public void readDocument(@RequestHeader String user, @RequestHeader String password, @PathVariable String path, HttpServletResponse response) {
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(user), new ReadKeyPassword(password));
        PrivateResource resource = BasePrivateResource.forPrivate((String)path);
        ReadRequest request = ReadRequest.forPrivate((Object)userIDAuth, (PrivateResource)resource);
        try (InputStream is = this.dataSafeService.privateService().read(request);
             ServletOutputStream os = response.getOutputStream();){
            StreamUtils.copy((InputStream)is, (OutputStream)os);
        }
        log.debug("User: {}, read private file from: {}", (Object)user, (Object)resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PutMapping(value={"/document/{path:.*}"}, consumes={"application/octet-stream"})
    public void writeDocument(@RequestHeader String user, @RequestHeader String password, @PathVariable String path, InputStream is) {
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(user), new ReadKeyPassword(password));
        WriteRequest request = WriteRequest.forDefaultPrivate((Object)userIDAuth, (String)path);
        try (OutputStream os = this.dataSafeService.privateService().write(request);){
            StreamUtils.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            is.close();
        }
        log.debug("User: {}, write private file to: {}", (Object)user, (Object)path);
    }

    @GetMapping(value={"/documents/{path:.*}"})
    public List<String> listDocuments(@RequestHeader String user, @RequestHeader String password, @PathVariable(required=false) String path) {
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(user), new ReadKeyPassword(password));
        path = Optional.ofNullable(path).orElse("./");
        List<String> documentList = this.dataSafeService.privateService().list(ListRequest.forDefaultPrivate((Object)userIDAuth, (String)path)).map(e -> ((ResolvedResource)e.getResource()).asPrivate().decryptedPath().getPath()).collect(Collectors.toList());
        log.debug("List for path {} returned {} items", (Object)path, (Object)documentList.size());
        return documentList;
    }

    @DeleteMapping(value={"/document/{path:.*}"})
    public void removeDocument(@RequestHeader String user, @RequestHeader String password, @PathVariable String path) {
        UserIDAuth userIDAuth = new UserIDAuth(new UserID(user), new ReadKeyPassword(password));
        PrivateResource resource = BasePrivateResource.forPrivate((String)path);
        RemoveRequest request = RemoveRequest.forPrivate((Object)userIDAuth, (PrivateResource)resource);
        this.dataSafeService.privateService().remove(request);
        log.debug("User: {}, delete private file: {}", (Object)user, (Object)resource);
    }

    @Generated
    public DocumentController(DefaultDatasafeServices dataSafeService) {
        this.dataSafeService = dataSafeService;
    }
}

