/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.rest.impl.controller;

import de.adorsys.datasafe.rest.impl.dto.UserDTO;
import de.adorsys.datasafe.rest.impl.security.SecurityProperties;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AuthenticateController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthenticateController.class);
    private final SecurityProperties securityProperties;
    private final AuthenticationManager authenticationManager;

    @PostMapping(value={"/api/authenticate"})
    public void authenticate(@RequestBody UserDTO credentialsDTO, HttpServletResponse response) {
        String username = credentialsDTO.getUserName();
        String password = credentialsDTO.getPassword();
        UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        Authentication authentication = this.authenticationManager.authenticate((Authentication)authenticationToken);
        User user = (User)authentication.getPrincipal();
        List roles = user.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList());
        byte[] signingKey = this.securityProperties.getJwtSecret().getBytes();
        String token = Jwts.builder().signWith((Key)Keys.hmacShaKeyFor((byte[])signingKey), SignatureAlgorithm.HS512).setHeaderParam("typ", (Object)"JWT").setIssuer("secure-api").setAudience("secure-app").setSubject(user.getUsername()).setExpiration(new Date(System.currentTimeMillis() + this.securityProperties.getTokenExpiration())).claim("rol", roles).compact();
        response.addHeader("token", "Bearer " + token);
    }

    @Generated
    public AuthenticateController(SecurityProperties securityProperties, AuthenticationManager authenticationManager) {
        this.securityProperties = securityProperties;
        this.authenticationManager = authenticationManager;
    }
}

