/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.rest.impl.config;

import com.amazonaws.services.s3.AmazonS3;
import de.adorsys.datasafe.business.impl.service.DaggerDefaultDatasafeServices;
import de.adorsys.datasafe.business.impl.service.DaggerVersionedDatasafeServices;
import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import de.adorsys.datasafe.business.impl.service.VersionedDatasafeServices;
import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.impl.profile.config.DefaultDFSConfig;
import de.adorsys.datasafe.rest.impl.config.DatasafeProperties;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.storage.impl.s3.S3StorageService;
import de.adorsys.datasafe.types.api.resource.Uri;
import java.security.Provider;
import java.security.Security;
import java.util.concurrent.Executors;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DatasafeConfig {
    @Bean
    DFSConfig dfsConfig(DatasafeProperties properties) {
        return new DefaultDFSConfig(new Uri(properties.getSystemRoot()), properties.getKeystorePassword());
    }

    @Bean
    StorageService storageService(AmazonS3 s3, DatasafeProperties properties) {
        return new S3StorageService(s3, properties.getBucketName(), Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()));
    }

    @Bean
    DefaultDatasafeServices datasafeService(StorageService storageService, DFSConfig dfsConfig) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        return DaggerDefaultDatasafeServices.builder().config(dfsConfig).storage(storageService).build();
    }

    @Bean
    VersionedDatasafeServices versionedDatasafeServices(StorageService storageService, DFSConfig dfsConfig) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        return DaggerVersionedDatasafeServices.builder().config(dfsConfig).storage(storageService).build();
    }
}

