package de.adorsys.datasafe.privatestore.impl;

import de.adorsys.datasafe.privatestore.api.actions.ListPrivate;
import de.adorsys.datasafe.privatestore.api.actions.ReadFromPrivate;
import de.adorsys.datasafe.privatestore.api.actions.RemoveFromPrivate;
import de.adorsys.datasafe.privatestore.api.actions.WriteToPrivate;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import jakarta.annotation.Generated;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class PrivateSpaceServiceImplRuntimeDelegatable extends PrivateSpaceServiceImpl {
    private final PrivateSpaceServiceImpl delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public PrivateSpaceServiceImplRuntimeDelegatable(@Nullable OverridesRegistry context,
            ListPrivate listPrivate, ReadFromPrivate readFromPrivate, WriteToPrivate writeToPrivate,
            RemoveFromPrivate removeFromPrivate) {
        super(listPrivate, readFromPrivate, writeToPrivate, removeFromPrivate);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(listPrivate, readFromPrivate, writeToPrivate, removeFromPrivate);
        delegate = context != null ? context.findOverride(PrivateSpaceServiceImpl.class, argumentsCaptor) : null;
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, PrivateSpaceServiceImpl> ctorCaptor) {
        context.override(PrivateSpaceServiceImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final ListPrivate listPrivate;

        private final ReadFromPrivate readFromPrivate;

        private final WriteToPrivate writeToPrivate;

        private final RemoveFromPrivate removeFromPrivate;

        private ArgumentsCaptor(ListPrivate listPrivate, ReadFromPrivate readFromPrivate,
                WriteToPrivate writeToPrivate, RemoveFromPrivate removeFromPrivate) {
            this.listPrivate = listPrivate;
            this.readFromPrivate = readFromPrivate;
            this.writeToPrivate = writeToPrivate;
            this.removeFromPrivate = removeFromPrivate;
        }

        public ListPrivate getListPrivate() {
            return listPrivate;
        }

        public ReadFromPrivate getReadFromPrivate() {
            return readFromPrivate;
        }

        public WriteToPrivate getWriteToPrivate() {
            return writeToPrivate;
        }

        public RemoveFromPrivate getRemoveFromPrivate() {
            return removeFromPrivate;
        }
    }
}
