package de.adorsys.datasafe.privatestore.impl.actions;

import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.privatestore.api.actions.EncryptedResourceResolver;
import de.adorsys.datasafe.storage.api.actions.StorageRemoveService;
import de.adorsys.datasafe.types.api.actions.RemoveRequest;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import java.lang.Override;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class RemoveFromPrivateImplRuntimeDelegatable extends RemoveFromPrivateImpl {
    private final RemoveFromPrivateImpl delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public RemoveFromPrivateImplRuntimeDelegatable(@Nullable OverridesRegistry context,
            EncryptedResourceResolver resolver, StorageRemoveService remover) {
        super(resolver, remover);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(resolver, remover);
        delegate = context != null ? context.findOverride(RemoveFromPrivateImpl.class, argumentsCaptor) : null;
    }

    @Override
    public void remove(RemoveRequest<UserIDAuth, PrivateResource> request) {
        if (null == delegate) {
            super.remove(request);
        } else {
            delegate.remove(request);
        }
    }

    @Override
    public void makeSurePasswordClearanceIsDone() {
        if (null == delegate) {
            super.makeSurePasswordClearanceIsDone();
        } else {
            delegate.makeSurePasswordClearanceIsDone();
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, RemoveFromPrivateImpl> ctorCaptor) {
        context.override(RemoveFromPrivateImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final EncryptedResourceResolver resolver;

        private final StorageRemoveService remover;

        private ArgumentsCaptor(EncryptedResourceResolver resolver, StorageRemoveService remover) {
            this.resolver = resolver;
            this.remover = remover;
        }

        public EncryptedResourceResolver getResolver() {
            return resolver;
        }

        public StorageRemoveService getRemover() {
            return remover;
        }
    }
}
