package de.adorsys.datasafe.privatestore.impl.actions;

import de.adorsys.datasafe.encrypiton.api.document.EncryptedDocumentReadService;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.privatestore.api.PasswordClearingInputStream;
import de.adorsys.datasafe.privatestore.api.actions.EncryptedResourceResolver;
import de.adorsys.datasafe.types.api.actions.ReadRequest;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import java.lang.Override;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class ReadFromPrivateImplRuntimeDelegatable extends ReadFromPrivateImpl {
    private final ReadFromPrivateImpl delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public ReadFromPrivateImplRuntimeDelegatable(@Nullable OverridesRegistry context,
            EncryptedResourceResolver resolver, EncryptedDocumentReadService reader) {
        super(resolver, reader);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(resolver, reader);
        delegate = context != null ? context.findOverride(ReadFromPrivateImpl.class, argumentsCaptor) : null;
    }

    @Override
    public PasswordClearingInputStream read(ReadRequest<UserIDAuth, PrivateResource> request) {
        if (null == delegate) {
            return super.read(request);
        } else {
            return delegate.read(request);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, ReadFromPrivateImpl> ctorCaptor) {
        context.override(ReadFromPrivateImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final EncryptedResourceResolver resolver;

        private final EncryptedDocumentReadService reader;

        private ArgumentsCaptor(EncryptedResourceResolver resolver,
                EncryptedDocumentReadService reader) {
            this.resolver = resolver;
            this.reader = reader;
        }

        public EncryptedResourceResolver getResolver() {
            return resolver;
        }

        public EncryptedDocumentReadService getReader() {
            return reader;
        }
    }
}
