package de.adorsys.datasafe.privatestore.impl.actions;

import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.privatestore.api.PasswordClearingStream;
import de.adorsys.datasafe.privatestore.api.actions.EncryptedResourceResolver;
import de.adorsys.datasafe.storage.api.actions.StorageListService;
import de.adorsys.datasafe.types.api.actions.ListRequest;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import java.lang.Override;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class ListPrivateImplRuntimeDelegatable extends ListPrivateImpl {
    private final ListPrivateImpl delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public ListPrivateImplRuntimeDelegatable(@Nullable OverridesRegistry context,
            EncryptedResourceResolver resolver, StorageListService listService) {
        super(resolver, listService);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(resolver, listService);
        delegate = context != null ? context.findOverride(ListPrivateImpl.class, argumentsCaptor) : null;
    }

    @Override
    public PasswordClearingStream<AbsoluteLocation<ResolvedResource>> list(
            ListRequest<UserIDAuth, PrivateResource> request) {
        if (null == delegate) {
            return super.list(request);
        } else {
            return delegate.list(request);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, ListPrivateImpl> ctorCaptor) {
        context.override(ListPrivateImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final EncryptedResourceResolver resolver;

        private final StorageListService listService;

        private ArgumentsCaptor(EncryptedResourceResolver resolver,
                StorageListService listService) {
            this.resolver = resolver;
            this.listService = listService;
        }

        public EncryptedResourceResolver getResolver() {
            return resolver;
        }

        public StorageListService getListService() {
            return listService;
        }
    }
}
