/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.privatestore.impl.actions;

import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.privatestore.api.actions.EncryptedResourceResolver;
import de.adorsys.datasafe.privatestore.api.actions.ListPrivate;
import de.adorsys.datasafe.storage.api.actions.StorageListService;
import de.adorsys.datasafe.types.api.actions.ListRequest;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.inject.Inject;

@RuntimeDelegate
public class ListPrivateImpl
implements ListPrivate {
    private final EncryptedResourceResolver resolver;
    private final StorageListService listService;

    @Inject
    public ListPrivateImpl(EncryptedResourceResolver resolver, StorageListService listService) {
        this.resolver = resolver;
        this.listService = listService;
    }

    public Stream<AbsoluteLocation<ResolvedResource>> list(ListRequest<UserIDAuth, PrivateResource> request) {
        AbsoluteLocation listDir = this.resolver.encryptAndResolvePath((UserIDAuth)request.getOwner(), (PrivateResource)request.getLocation(), request.getStorageIdentifier());
        Function decryptingResolver = this.resolver.decryptingResolver((UserIDAuth)request.getOwner(), (PrivateResource)listDir.getResource(), request.getStorageIdentifier());
        return this.listService.list(listDir).map(it -> {
            AbsoluteLocation decrypted = (AbsoluteLocation)decryptingResolver.apply(((ResolvedResource)it.getResource()).asPrivate());
            return new AbsoluteLocation((ResourceLocation)((ResolvedResource)it.getResource()).withResource((PrivateResource)decrypted.getResource()));
        });
    }
}

