package de.adorsys.datasafe.privatestore.impl.actions;

import de.adorsys.datasafe.directory.api.profile.keys.PrivateKeyService;
import de.adorsys.datasafe.encrypiton.api.document.EncryptedDocumentWriteService;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.privatestore.api.actions.EncryptedResourceResolver;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import java.io.OutputStream;
import java.lang.Override;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class WriteToPrivateImplRuntimeDelegatable extends WriteToPrivateImpl {
    private final WriteToPrivateImpl delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public WriteToPrivateImplRuntimeDelegatable(@Nullable OverridesRegistry context,
            PrivateKeyService privateKeyService, EncryptedResourceResolver resolver,
            EncryptedDocumentWriteService writer) {
        super(privateKeyService, resolver, writer);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(privateKeyService, resolver, writer);
        delegate = context != null ? context.findOverride(WriteToPrivateImpl.class, argumentsCaptor) : null;
    }

    @Override
    public OutputStream write(WriteRequest<UserIDAuth, PrivateResource> request) {
        if (null == delegate) {
            return super.write(request);
        } else {
            return delegate.write(request);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, WriteToPrivateImpl> ctorCaptor) {
        context.override(WriteToPrivateImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final PrivateKeyService privateKeyService;

        private final EncryptedResourceResolver resolver;

        private final EncryptedDocumentWriteService writer;

        private ArgumentsCaptor(PrivateKeyService privateKeyService,
                EncryptedResourceResolver resolver, EncryptedDocumentWriteService writer) {
            this.privateKeyService = privateKeyService;
            this.resolver = resolver;
            this.writer = writer;
        }

        public PrivateKeyService getPrivateKeyService() {
            return privateKeyService;
        }

        public EncryptedResourceResolver getResolver() {
            return resolver;
        }

        public EncryptedDocumentWriteService getWriter() {
            return writer;
        }
    }
}
