package de.adorsys.datasafe.privatestore.impl.actions;

import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.resource.ResourceResolver;
import de.adorsys.datasafe.encrypiton.api.pathencryption.PathEncryption;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import java.lang.Override;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class EncryptedResourceResolverImplRuntimeDelegatable extends EncryptedResourceResolverImpl {
    private final EncryptedResourceResolverImpl delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public EncryptedResourceResolverImplRuntimeDelegatable(@Nullable OverridesRegistry context,
            BucketAccessService bucketAccessService, ResourceResolver resolver,
            PathEncryption pathEncryption) {
        super(bucketAccessService, resolver, pathEncryption);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(bucketAccessService, resolver, pathEncryption);
        delegate = context != null ? context.findOverride(EncryptedResourceResolverImpl.class, argumentsCaptor) : null;
    }

    @Override
    public AbsoluteLocation<PrivateResource> encryptAndResolvePath(UserIDAuth auth,
            PrivateResource resource) {
        if (null == delegate) {
            return super.encryptAndResolvePath(auth, resource);
        } else {
            return delegate.encryptAndResolvePath(auth, resource);
        }
    }

    @Override
    public AbsoluteLocation<PrivateResource> decryptAndResolvePath(UserIDAuth auth,
            PrivateResource resource, PrivateResource root) {
        if (null == delegate) {
            return super.decryptAndResolvePath(auth, resource, root);
        } else {
            return delegate.decryptAndResolvePath(auth, resource, root);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, EncryptedResourceResolverImpl> ctorCaptor) {
        context.override(EncryptedResourceResolverImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final BucketAccessService bucketAccessService;

        private final ResourceResolver resolver;

        private final PathEncryption pathEncryption;

        private ArgumentsCaptor(BucketAccessService bucketAccessService, ResourceResolver resolver,
                PathEncryption pathEncryption) {
            this.bucketAccessService = bucketAccessService;
            this.resolver = resolver;
            this.pathEncryption = pathEncryption;
        }

        public BucketAccessService getBucketAccessService() {
            return bucketAccessService;
        }

        public ResourceResolver getResolver() {
            return resolver;
        }

        public PathEncryption getPathEncryption() {
            return pathEncryption;
        }
    }
}
