/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.privatestore.impl.actions;

import de.adorsys.datasafe.directory.api.profile.keys.PrivateKeyService;
import de.adorsys.datasafe.encrypiton.api.document.EncryptedDocumentWriteService;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.SecretKeyIDWithKey;
import de.adorsys.datasafe.privatestore.api.actions.EncryptedResourceResolver;
import de.adorsys.datasafe.privatestore.api.actions.WriteToPrivate;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import java.io.OutputStream;
import javax.inject.Inject;

@RuntimeDelegate
public class WriteToPrivateImpl
implements WriteToPrivate {
    private final PrivateKeyService privateKeyService;
    private final EncryptedResourceResolver resolver;
    private final EncryptedDocumentWriteService writer;

    @Inject
    public WriteToPrivateImpl(PrivateKeyService privateKeyService, EncryptedResourceResolver resolver, EncryptedDocumentWriteService writer) {
        this.privateKeyService = privateKeyService;
        this.resolver = resolver;
        this.writer = writer;
    }

    public OutputStream write(WriteRequest<UserIDAuth, PrivateResource> request) {
        SecretKeyIDWithKey keySpec = this.privateKeyService.documentEncryptionSecretKey((UserIDAuth)request.getOwner());
        return this.writer.write(this.resolver.encryptAndResolvePath((UserIDAuth)request.getOwner(), (PrivateResource)request.getLocation()), keySpec);
    }
}

