/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.privatestore.impl.actions;

import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.resource.ResourceResolver;
import de.adorsys.datasafe.encrypiton.api.pathencryption.PathEncryption;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.privatestore.api.actions.EncryptedResourceResolver;
import de.adorsys.datasafe.types.api.context.annotations.RuntimeDelegate;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import de.adorsys.datasafe.types.api.resource.Uri;
import javax.inject.Inject;

@RuntimeDelegate
public class EncryptedResourceResolverImpl
implements EncryptedResourceResolver {
    private final BucketAccessService bucketAccessService;
    private final ResourceResolver resolver;
    private final PathEncryption pathEncryption;

    @Inject
    public EncryptedResourceResolverImpl(BucketAccessService bucketAccessService, ResourceResolver resolver, PathEncryption pathEncryption) {
        this.bucketAccessService = bucketAccessService;
        this.resolver = resolver;
        this.pathEncryption = pathEncryption;
    }

    public AbsoluteLocation<PrivateResource> encryptAndResolvePath(UserIDAuth auth, PrivateResource resource) {
        if (this.resolver.isAbsolute((ResourceLocation)resource)) {
            return this.bucketAccessService.privateAccessFor(auth, resource);
        }
        return this.resolver.resolveRelativeToPrivate(auth, this.encrypt(auth, resource));
    }

    public AbsoluteLocation<PrivateResource> decryptAndResolvePath(UserIDAuth auth, PrivateResource resource, PrivateResource root) {
        if (!this.resolver.isAbsolute((ResourceLocation)resource)) {
            Uri encryptedPath = resource.location();
            Uri decryptedPath = this.pathEncryption.decrypt(auth, encryptedPath);
            return new AbsoluteLocation((ResourceLocation)((PrivateResource)this.resolver.resolveRelativeToPrivate(auth, resource).getResource()).resolve(encryptedPath, decryptedPath));
        }
        Uri relative = EncryptedResourceResolverImpl.relativize(root.location(), resource.location());
        Uri encryptedPath = this.computeEncryptedPath(root, relative);
        Uri decryptedPath = this.pathEncryption.decrypt(auth, encryptedPath);
        return new AbsoluteLocation((ResourceLocation)((PrivateResource)this.resolver.resolveRelativeToPrivate(auth, resource).getResource()).resolve(encryptedPath, decryptedPath));
    }

    private PrivateResource encrypt(UserIDAuth auth, PrivateResource resource) {
        Uri decryptedPath = resource.location();
        Uri encryptedRelativePath = this.pathEncryption.encrypt(auth, decryptedPath);
        return resource.resolve(encryptedRelativePath, decryptedPath);
    }

    private Uri computeEncryptedPath(PrivateResource root, Uri relative) {
        if (this.hasRelativePath(relative)) {
            return this.handleResourceRelativeToRoot(root, relative);
        }
        return this.handleEmptyRelative(root);
    }

    private boolean hasRelativePath(Uri relative) {
        return !relative.isEmpty();
    }

    private Uri handleEmptyRelative(PrivateResource root) {
        return root.encryptedPath();
    }

    private Uri handleResourceRelativeToRoot(PrivateResource root, Uri relative) {
        if (root.encryptedPath().isEmpty()) {
            return relative;
        }
        return root.encryptedPath().asDir().resolve(relative);
    }

    private static Uri relativize(Uri root, Uri resource) {
        if (root.isAbsolute()) {
            return root.relativize(resource);
        }
        String rootString = root.toASCIIString();
        String resourceString = resource.toASCIIString();
        String relative = resourceString.substring(resourceString.indexOf(rootString) + rootString.length());
        return new Uri(relative);
    }
}

