/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.privatestore.impl.actions;

import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.privatestore.api.actions.EncryptedResourceResolver;
import de.adorsys.datasafe.privatestore.api.actions.ListPrivate;
import de.adorsys.datasafe.storage.api.actions.StorageListService;
import de.adorsys.datasafe.types.api.actions.ListRequest;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import java.util.stream.Stream;
import javax.inject.Inject;

public class ListPrivateImpl
implements ListPrivate {
    private final EncryptedResourceResolver resolver;
    private final StorageListService listService;

    @Inject
    public ListPrivateImpl(EncryptedResourceResolver resolver, StorageListService listService) {
        this.resolver = resolver;
        this.listService = listService;
    }

    public Stream<AbsoluteLocation<ResolvedResource>> list(ListRequest<UserIDAuth, PrivateResource> request) {
        AbsoluteLocation listDir = this.resolver.encryptAndResolvePath((UserIDAuth)request.getOwner(), (PrivateResource)request.getLocation());
        return this.listService.list(listDir).map(it -> this.decryptPath((UserIDAuth)request.getOwner(), (AbsoluteLocation<ResolvedResource>)it, (PrivateResource)listDir.getResource()));
    }

    private AbsoluteLocation<ResolvedResource> decryptPath(UserIDAuth owner, AbsoluteLocation<ResolvedResource> resource, PrivateResource root) {
        AbsoluteLocation decrypted = this.resolver.decryptAndResolvePath(owner, ((ResolvedResource)resource.getResource()).asPrivate(), root);
        return new AbsoluteLocation((ResourceLocation)((ResolvedResource)resource.getResource()).withResource((PrivateResource)decrypted.getResource()));
    }
}

