/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafemigration.withDFSonly;

import de.adorsys.datasafe_0_6_1.simple.adapter.api.S061_SimpleDatasafeService;
import de.adorsys.datasafe_0_6_1.simple.adapter.api.types.S061_DSDocument;
import de.adorsys.datasafe_0_6_1.simple.adapter.api.types.S061_DocumentDirectoryFQN;
import de.adorsys.datasafe_0_6_1.simple.adapter.api.types.S061_DocumentFQN;
import de.adorsys.datasafe_0_6_1.simple.adapter.api.types.S061_ListRecursiveFlag;
import de.adorsys.datasafe_1_0_3.encrypiton.api.types.S103_UserIDAuth;
import de.adorsys.datasafe_1_0_3.simple.adapter.api.S103_SimpleDatasafeService;
import de.adorsys.datasafe_1_0_3.simple.adapter.api.types.S103_DSDocument;
import de.adorsys.datasafemigration.common.SwitchVersion;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadUserOldToNewFormat {
    private static final Logger log = LoggerFactory.getLogger(LoadUserOldToNewFormat.class);
    private final S061_SimpleDatasafeService sourceDatasafeService;
    private final S103_SimpleDatasafeService destDatasafeService;

    public MigrationInfo migrateUser(S103_UserIDAuth userIDAuth) {
        MigrationInfo migrationInfo = new MigrationInfo();
        Instant start = Instant.now();
        this.createUser(userIDAuth);
        List list = this.sourceDatasafeService.list(SwitchVersion.to_0_6_1(userIDAuth), new S061_DocumentDirectoryFQN("/"), S061_ListRecursiveFlag.TRUE);
        for (S061_DocumentFQN fqn : list) {
            S061_DSDocument dsDocument = this.sourceDatasafeService.readDocument(SwitchVersion.to_0_6_1(userIDAuth), fqn);
            this.storeDocument(userIDAuth, SwitchVersion.to_1_0_3(dsDocument));
            migrationInfo.incrementFiles();
            migrationInfo.addBytes(dsDocument.getDocumentContent().getValue().length);
        }
        migrationInfo.setDuration(Duration.between(start, Instant.now()));
        return migrationInfo;
    }

    private void createUser(S103_UserIDAuth userIDAuth) {
        if (this.destDatasafeService.userExists(userIDAuth.getUserID())) {
            throw new RuntimeException("user " + userIDAuth.getUserID().getValue() + " already exists");
        }
        this.destDatasafeService.createUser(userIDAuth);
        log.debug("created user {} in new format", (Object)userIDAuth.getUserID().getValue());
    }

    private void storeDocument(S103_UserIDAuth userIDAuth, S103_DSDocument dsDocument) {
        this.destDatasafeService.storeDocument(userIDAuth, dsDocument);
        log.debug("stored document of size {} in new format for user {}", (Object)dsDocument.getDocumentContent().getValue().length, (Object)userIDAuth.getUserID().getValue());
    }

    public LoadUserOldToNewFormat(S061_SimpleDatasafeService sourceDatasafeService, S103_SimpleDatasafeService destDatasafeService) {
        this.sourceDatasafeService = sourceDatasafeService;
        this.destDatasafeService = destDatasafeService;
    }

    public static class MigrationInfo {
        Duration duration;
        Date startTime = new Date();
        long files = 0L;
        long bytes = 0L;

        public void incrementFiles() {
            ++this.files;
        }

        public void addBytes(long number) {
            this.bytes += number;
        }

        public void setDuration(Duration d) {
            this.duration = d;
        }

        public String toString() {
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH.mm.ss,SSS");
            StringBuilder sb = new StringBuilder();
            sb.append("Migration started at ").append(sdf.format(this.startTime)).append(" and took ").append(this.duration.toMillis()).append(" milliseconds. ").append(this.files).append(" files with ").append(this.bytes).append(" bytes have been migrated.");
            return sb.toString();
        }

        public Duration getDuration() {
            return this.duration;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public long getFiles() {
            return this.files;
        }

        public long getBytes() {
            return this.bytes;
        }
    }
}

