/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafemigration.withDFSonly;

import de.adorsys.datasafe_1_0_3.encrypiton.api.types.S103_UserIDAuth;
import de.adorsys.datasafe_1_0_3.simple.adapter.api.S103_SimpleDatasafeService;
import de.adorsys.datasafe_1_0_3.simple.adapter.api.types.S103_DSDocument;
import de.adorsys.datasafe_1_0_3.simple.adapter.api.types.S103_DocumentDirectoryFQN;
import de.adorsys.datasafe_1_0_3.simple.adapter.api.types.S103_DocumentFQN;
import de.adorsys.datasafe_1_0_3.simple.adapter.api.types.S103_ListRecursiveFlag;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadUserNewToNewFormat {
    private static final Logger log = LoggerFactory.getLogger(LoadUserNewToNewFormat.class);
    private final S103_SimpleDatasafeService sourceDatasafeService;
    private final S103_SimpleDatasafeService destDatasafeService;

    public void migrateUser(S103_UserIDAuth userIDAuth) {
        this.createUser(userIDAuth);
        List list = this.sourceDatasafeService.list(userIDAuth, new S103_DocumentDirectoryFQN("/"), S103_ListRecursiveFlag.TRUE);
        for (S103_DocumentFQN fqn : list) {
            S103_DSDocument dsDocument = this.sourceDatasafeService.readDocument(userIDAuth, fqn);
            this.storeDocument(userIDAuth, dsDocument);
        }
    }

    private void createUser(S103_UserIDAuth userIDAuth) {
        if (this.destDatasafeService.userExists(userIDAuth.getUserID())) {
            throw new RuntimeException("user " + userIDAuth.getUserID().getValue() + " already exists");
        }
        this.destDatasafeService.createUser(userIDAuth);
        log.debug("created user {} in new format", (Object)userIDAuth.getUserID().getValue());
    }

    private void storeDocument(S103_UserIDAuth userIDAuth, S103_DSDocument dsDocument) {
        this.destDatasafeService.storeDocument(userIDAuth, dsDocument);
        log.debug("stored document of size {} in new format for user {}", (Object)dsDocument.getDocumentContent().getValue().length, (Object)userIDAuth.getUserID().getValue());
    }

    public LoadUserNewToNewFormat(S103_SimpleDatasafeService sourceDatasafeService, S103_SimpleDatasafeService destDatasafeService) {
        this.sourceDatasafeService = sourceDatasafeService;
        this.destDatasafeService = destDatasafeService;
    }
}

