/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafemigration.withDFSonly;

import de.adorsys.datasafe_1_0_0.encrypiton.api.types.S100_UserIDAuth;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.S100_SimpleDatasafeService;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.types.S100_DSDocument;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.types.S100_DocumentDirectoryFQN;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.types.S100_DocumentFQN;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.types.S100_ListRecursiveFlag;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadUserNewToNewFormat {
    private static final Logger log = LoggerFactory.getLogger(LoadUserNewToNewFormat.class);
    private final S100_SimpleDatasafeService sourceDatasafeService;
    private final S100_SimpleDatasafeService destDatasafeService;

    public void migrateUser(S100_UserIDAuth userIDAuth) {
        this.createUser(userIDAuth);
        List list = this.sourceDatasafeService.list(userIDAuth, new S100_DocumentDirectoryFQN("/"), S100_ListRecursiveFlag.TRUE);
        for (S100_DocumentFQN fqn : list) {
            S100_DSDocument dsDocument = this.sourceDatasafeService.readDocument(userIDAuth, fqn);
            this.storeDocument(userIDAuth, dsDocument);
        }
    }

    private void createUser(S100_UserIDAuth userIDAuth) {
        if (this.destDatasafeService.userExists(userIDAuth.getUserID())) {
            throw new RuntimeException("user " + userIDAuth.getUserID().getValue() + " already exists");
        }
        this.destDatasafeService.createUser(userIDAuth);
        log.debug("created user {} in new format", (Object)userIDAuth.getUserID().getValue());
    }

    private void storeDocument(S100_UserIDAuth userIDAuth, S100_DSDocument dsDocument) {
        this.destDatasafeService.storeDocument(userIDAuth, dsDocument);
        log.debug("stored document of size {} in new format for user {}", (Object)dsDocument.getDocumentContent().getValue().length, (Object)userIDAuth.getUserID().getValue());
    }

    public LoadUserNewToNewFormat(S100_SimpleDatasafeService sourceDatasafeService, S100_SimpleDatasafeService destDatasafeService) {
        this.sourceDatasafeService = sourceDatasafeService;
        this.destDatasafeService = destDatasafeService;
    }
}

