/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafemigration.withlocalfilesystem;

import de.adorsys.datasafe_1_0_0.encrypiton.api.types.S100_UserIDAuth;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.S100_SimpleDatasafeService;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.types.S100_DSDocument;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.types.S100_DocumentContent;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.types.S100_DocumentDirectoryFQN;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.types.S100_DocumentFQN;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteNewUserFromLocal {
    private static final Logger log = LoggerFactory.getLogger(WriteNewUserFromLocal.class);
    private final S100_SimpleDatasafeService simpleDatasafeService;
    private final S100_DocumentDirectoryFQN src;

    public void migrateUser(S100_UserIDAuth userIDAuth) {
        if (this.simpleDatasafeService.userExists(userIDAuth.getUserID())) {
            throw new RuntimeException("user " + userIDAuth.getUserID().getValue() + " already exists in new format");
        }
        this.simpleDatasafeService.createUser(userIDAuth);
        log.debug("create user {} in new format", (Object)userIDAuth.getUserID().getValue());
        String sourcedir = this.src.addDirectory(userIDAuth.getUserID().getValue()).getDocusafePath();
        try (Stream<Path> walk = Files.walk(Paths.get(sourcedir, new String[0]), new FileVisitOption[0]);){
            List result = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(x -> x.toString()).collect(Collectors.toList());
            for (String path : result) {
                S100_DocumentFQN fqn = new S100_DocumentFQN(path.substring(sourcedir.length()));
                S100_DSDocument dsDocument = new S100_DSDocument(fqn, new S100_DocumentContent(Files.readAllBytes(Paths.get(path, new String[0]))));
                this.simpleDatasafeService.storeDocument(userIDAuth, dsDocument);
                log.debug("stored {} bytes for file {} in new format", (Object)dsDocument.getDocumentContent().getValue().length, (Object)dsDocument.getDocumentFQN().getDocusafePath());
            }
        }
    }

    public WriteNewUserFromLocal(S100_SimpleDatasafeService simpleDatasafeService, S100_DocumentDirectoryFQN src) {
        this.simpleDatasafeService = simpleDatasafeService;
        this.src = src;
    }
}

