/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafemigration.withlocalfilesystem;

import de.adorsys.datasafe_0_6_1.simple.adapter.api.S061_SimpleDatasafeService;
import de.adorsys.datasafe_0_6_1.simple.adapter.api.types.S061_DSDocument;
import de.adorsys.datasafe_0_6_1.simple.adapter.api.types.S061_DocumentDirectoryFQN;
import de.adorsys.datasafe_0_6_1.simple.adapter.api.types.S061_DocumentFQN;
import de.adorsys.datasafe_0_6_1.simple.adapter.api.types.S061_ListRecursiveFlag;
import de.adorsys.datasafe_1_0_0.encrypiton.api.types.S100_UserIDAuth;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.types.S100_DocumentDirectoryFQN;
import de.adorsys.datasafemigration.common.SwitchVersion;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.Provider;
import java.security.Security;
import java.util.List;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadOldUserToLocal {
    private static final Logger log = LoggerFactory.getLogger(LoadOldUserToLocal.class);
    private final S061_SimpleDatasafeService simpleDatasafeService;
    private final S100_DocumentDirectoryFQN dest;

    public void migrateUser(S100_UserIDAuth userIDAuth) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        List list = this.simpleDatasafeService.list(SwitchVersion.to_0_6_1((S100_UserIDAuth)userIDAuth), new S061_DocumentDirectoryFQN("/"), S061_ListRecursiveFlag.TRUE);
        for (S061_DocumentFQN fqn : list) {
            S061_DSDocument dsDocument = this.simpleDatasafeService.readDocument(SwitchVersion.to_0_6_1((S100_UserIDAuth)userIDAuth), fqn);
            this.store(dsDocument, SwitchVersion.to_0_6_1((S100_DocumentDirectoryFQN)this.dest).addDirectory(userIDAuth.getUserID().getValue()));
        }
    }

    private void store(S061_DSDocument dsDocument, S061_DocumentDirectoryFQN dest) {
        log.debug("store {} bytes in local file {} from old format", (Object)dsDocument.getDocumentContent().getValue().length, (Object)dsDocument.getDocumentFQN().getDatasafePath());
        Path localFileToWrite = Paths.get(dest.addDirectory(dsDocument.getDocumentFQN().getDocusafePath()).getDocusafePath(), new String[0]);
        Files.createDirectories(localFileToWrite.getParent(), new FileAttribute[0]);
        Files.write(localFileToWrite, dsDocument.getDocumentContent().getValue(), new OpenOption[0]);
    }

    public LoadOldUserToLocal(S061_SimpleDatasafeService simpleDatasafeService, S100_DocumentDirectoryFQN dest) {
        this.simpleDatasafeService = simpleDatasafeService;
        this.dest = dest;
    }
}

