/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafemigration.withlocalfilesystem;

import de.adorsys.datasafe_1_0_0.encrypiton.api.types.S100_UserIDAuth;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.S100_SimpleDatasafeService;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.types.S100_DSDocument;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.types.S100_DocumentDirectoryFQN;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.types.S100_DocumentFQN;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.types.S100_ListRecursiveFlag;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.Provider;
import java.security.Security;
import java.util.List;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadNewUserToLocal {
    private static final Logger log = LoggerFactory.getLogger(LoadNewUserToLocal.class);
    private final S100_SimpleDatasafeService simpleDatasafeService;
    private final S100_DocumentDirectoryFQN dest;

    public void migrateUser(S100_UserIDAuth userIDAuth) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        List list = this.simpleDatasafeService.list(userIDAuth, new S100_DocumentDirectoryFQN("/"), S100_ListRecursiveFlag.TRUE);
        for (S100_DocumentFQN fqn : list) {
            S100_DSDocument dsDocument = this.simpleDatasafeService.readDocument(userIDAuth, fqn);
            this.store(dsDocument, this.dest.addDirectory(userIDAuth.getUserID().getValue()));
        }
    }

    private void store(S100_DSDocument dsDocument, S100_DocumentDirectoryFQN dest) {
        log.debug("store {} bytes in local file {} from new format", (Object)dsDocument.getDocumentContent().getValue().length, (Object)dsDocument.getDocumentFQN().getDatasafePath());
        Path localFileToWrite = Paths.get(dest.addDirectory(dsDocument.getDocumentFQN().getDocusafePath()).getDocusafePath(), new String[0]);
        Files.createDirectories(localFileToWrite.getParent(), new FileAttribute[0]);
        Files.write(localFileToWrite, dsDocument.getDocumentContent().getValue(), new OpenOption[0]);
    }

    public LoadNewUserToLocal(S100_SimpleDatasafeService simpleDatasafeService, S100_DocumentDirectoryFQN dest) {
        this.simpleDatasafeService = simpleDatasafeService;
        this.dest = dest;
    }
}

