/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafemigration.offline;

import de.adorsys.datasafe_1_0_0.encrypiton.api.types.S100_UserID;
import de.adorsys.datasafe_1_0_0.encrypiton.api.types.S100_UserIDAuth;
import de.adorsys.datasafe_1_0_0.types.api.types.S100_ReadKeyPassword;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadUserPasswordFile {
    private static final Logger log = LoggerFactory.getLogger(ReadUserPasswordFile.class);

    public static List<S100_UserIDAuth> getAllUsers(String filename) {
        ArrayList<S100_UserIDAuth> list = new ArrayList<S100_UserIDAuth>();
        try (BufferedReader reader = new BufferedReader(new FileReader(filename));){
            String line = reader.readLine();
            if (!line.startsWith("#") && line.replaceAll(" ", "").length() != 0) {
                int delimiter = line.indexOf(" ");
                String username = line.substring(0, delimiter);
                String password = line.substring(delimiter + 1);
                Supplier<char[]> passwordSupplier = password::toCharArray;
                list.add(new S100_UserIDAuth(new S100_UserID(username), new S100_ReadKeyPassword(passwordSupplier)));
            }
        }
        log.debug("read {} user from {}", (Object)list.size(), (Object)filename);
        return list;
    }
}

