/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafemigration.offline;

import de.adorsys.datasafe_0_6_1.simple.adapter.api.S061_SimpleDatasafeService;
import de.adorsys.datasafe_0_6_1.simple.adapter.api.types.S061_AmazonS3DFSCredentials;
import de.adorsys.datasafe_0_6_1.simple.adapter.api.types.S061_DFSCredentials;
import de.adorsys.datasafe_0_6_1.simple.adapter.impl.S061_SimpleDatasafeServiceImpl;
import de.adorsys.datasafe_1_0_0.encrypiton.api.types.S100_UserIDAuth;
import de.adorsys.datasafe_1_0_0.encrypiton.api.types.encryption.MutableEncryptionConfig;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.S100_SimpleDatasafeService;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.types.S100_AmazonS3DFSCredentials;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.types.S100_DFSCredentials;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.types.S100_DocumentDirectoryFQN;
import de.adorsys.datasafe_1_0_0.simple.adapter.impl.S100_SimpleDatasafeServiceImpl;
import de.adorsys.datasafemigration.offline.ReadUserPasswordFile;
import de.adorsys.datasafemigration.withDFSonly.LoadUserNewToNewFormat;
import de.adorsys.datasafemigration.withDFSonly.LoadUserOldToNewFormat;
import de.adorsys.datasafemigration.withlocalfilesystem.LoadNewUserToLocal;
import de.adorsys.datasafemigration.withlocalfilesystem.LoadOldUserToLocal;
import de.adorsys.datasafemigration.withlocalfilesystem.WriteNewUserFromLocal;
import de.adorsys.datasafemigration.withlocalfilesystem.WriteOldUserFromLocal;
import java.security.Provider;
import java.security.Security;
import java.util.List;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Main {
    public static final String USERLISTFILE = "userlistfile";
    public static final String ACTION = "action";
    public static final String LOAD_OLD_TO_LOCAL = "loadOldToLocal";
    public static final String LOAD_NEW_TO_LOCAL = "loadNewToLocal";
    public static final String STORE_LOCAL_TO_NEW = "storeLocalToNew";
    public static final String STORE_LOCAL_TO_OLD = "storeLocalToOld";
    public static final String LOCALFOLDER = "localfolder";
    public static final String MIGRATE_DFS_TO_INTERMEDIATE = "migrateDFSToIntermediate";
    public static final String MIGRATE_DFS_FROM_INTERMEDIATE = "migrateDFSFromIntermediate";
    public static final String OLD = "old";
    public static final String NEW = "new";
    public static final String ACCESSKEY = "-accesskey";
    public static final String SECRETKEY = "-secretkey";
    public static final String ROOTBUCKET = "-rootbucket";
    public static final String URL = "-url";
    public static final String REGION = "-region";
    public static final String HTTPS = "https";

    public static void main(String[] args) {
        S100_SimpleDatasafeServiceImpl intermediateService;
        Object service;
        S061_SimpleDatasafeServiceImpl simpleDatasafeService;
        S100_DocumentDirectoryFQN localfolder;
        Security.addProvider((Provider)new BouncyCastleProvider());
        List<S100_UserIDAuth> usersToMigrate = ReadUserPasswordFile.getAllUsers(Main.get(args, USERLISTFILE));
        if (Main.get(args, ACTION).equals(LOAD_OLD_TO_LOCAL)) {
            localfolder = new S100_DocumentDirectoryFQN(Main.get(args, LOCALFOLDER));
            simpleDatasafeService = new S061_SimpleDatasafeServiceImpl(Main.getOldDfsCredentials(args));
            service = new LoadOldUserToLocal((S061_SimpleDatasafeService)simpleDatasafeService, localfolder);
            for (S100_UserIDAuth userIDAuth : usersToMigrate) {
                ((LoadOldUserToLocal)service).migrateUser(userIDAuth);
            }
        }
        if (Main.get(args, ACTION).equals(LOAD_NEW_TO_LOCAL)) {
            localfolder = new S100_DocumentDirectoryFQN(Main.get(args, LOCALFOLDER));
            simpleDatasafeService = new S100_SimpleDatasafeServiceImpl(Main.getNewDfsCredentials(NEW, args), new MutableEncryptionConfig());
            service = new LoadNewUserToLocal((S100_SimpleDatasafeService)simpleDatasafeService, localfolder);
            for (S100_UserIDAuth userIDAuth : usersToMigrate) {
                ((LoadNewUserToLocal)service).migrateUser(userIDAuth);
            }
        }
        if (Main.get(args, ACTION).equals(STORE_LOCAL_TO_NEW)) {
            localfolder = new S100_DocumentDirectoryFQN(Main.get(args, LOCALFOLDER));
            simpleDatasafeService = new S100_SimpleDatasafeServiceImpl(Main.getNewDfsCredentials(NEW, args), new MutableEncryptionConfig());
            service = new WriteNewUserFromLocal((S100_SimpleDatasafeService)simpleDatasafeService, localfolder);
            for (S100_UserIDAuth userIDAuth : usersToMigrate) {
                ((WriteNewUserFromLocal)service).migrateUser(userIDAuth);
            }
        }
        if (Main.get(args, ACTION).equals(STORE_LOCAL_TO_OLD)) {
            localfolder = new S100_DocumentDirectoryFQN(Main.get(args, LOCALFOLDER));
            simpleDatasafeService = new S061_SimpleDatasafeServiceImpl(Main.getOldDfsCredentials(args));
            service = new WriteOldUserFromLocal((S061_SimpleDatasafeService)simpleDatasafeService, localfolder);
            for (S100_UserIDAuth userIDAuth : usersToMigrate) {
                ((WriteOldUserFromLocal)service).migrateUser(userIDAuth);
            }
        }
        if (Main.get(args, ACTION).equals(MIGRATE_DFS_TO_INTERMEDIATE)) {
            intermediateService = new S100_SimpleDatasafeServiceImpl(Main.getNewDfsCredentials("intermediate", args), new MutableEncryptionConfig());
            S061_SimpleDatasafeServiceImpl oldService = new S061_SimpleDatasafeServiceImpl(Main.getOldDfsCredentials(args));
            LoadUserOldToNewFormat old = new LoadUserOldToNewFormat((S061_SimpleDatasafeService)oldService, (S100_SimpleDatasafeService)intermediateService);
            for (S100_UserIDAuth userIDAuth : usersToMigrate) {
                old.migrateUser(userIDAuth);
            }
        }
        if (Main.get(args, ACTION).equals(MIGRATE_DFS_FROM_INTERMEDIATE)) {
            intermediateService = new S100_SimpleDatasafeServiceImpl(Main.getNewDfsCredentials("intermediate", args), new MutableEncryptionConfig());
            S100_SimpleDatasafeServiceImpl newService = new S100_SimpleDatasafeServiceImpl(Main.getNewDfsCredentials(NEW, args), new MutableEncryptionConfig());
            LoadUserNewToNewFormat intermediateRead = new LoadUserNewToNewFormat((S100_SimpleDatasafeService)intermediateService, (S100_SimpleDatasafeService)newService);
            for (S100_UserIDAuth userIDAuth : usersToMigrate) {
                intermediateRead.migrateUser(userIDAuth);
            }
        }
    }

    private static S061_DFSCredentials getOldDfsCredentials(String[] args) {
        String prefix = OLD;
        return S061_AmazonS3DFSCredentials.builder().accessKey(Main.get(args, prefix + ACCESSKEY)).secretKey(Main.get(args, prefix + SECRETKEY)).rootBucket(Main.get(args, prefix + ROOTBUCKET)).url(Main.get(args, prefix + URL)).noHttps(!Main.get(args, prefix + URL).startsWith(HTTPS)).region(Main.get(args, prefix + REGION)).build();
    }

    private static S100_DFSCredentials getNewDfsCredentials(String prefix, String[] args) {
        return S100_AmazonS3DFSCredentials.builder().accessKey(Main.get(args, prefix + ACCESSKEY)).secretKey(Main.get(args, prefix + SECRETKEY)).rootBucket(Main.get(args, prefix + ROOTBUCKET)).url(Main.get(args, prefix + URL)).noHttps(!Main.get(args, prefix + URL).startsWith(HTTPS)).region(Main.get(args, prefix + REGION)).build();
    }

    private static String get(String[] args, String argToSearch) {
        for (String arg : args) {
            if (!arg.startsWith(argToSearch + "=")) continue;
            return arg.substring(argToSearch.length() + 1);
        }
        throw new RuntimeException("mandatory parameter " + argToSearch + " not found.");
    }
}

