/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafemigration.docker;

import de.adorsys.datasafe_0_6_1.simple.adapter.api.types.S061_AmazonS3DFSCredentials;
import de.adorsys.datasafe_0_6_1.simple.adapter.api.types.S061_DFSCredentials;
import de.adorsys.datasafe_0_6_1.simple.adapter.api.types.S061_FilesystemDFSCredentials;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.exceptions.SimpleAdapterException;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.types.S100_AmazonS3DFSCredentials;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.types.S100_DFSCredentials;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.types.S100_FilesystemDFSCredentials;
import de.adorsys.datasafemigration.docker.WithStorageProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InitFromStorageProvider {
    private static final Logger log = LoggerFactory.getLogger(InitFromStorageProvider.class);

    public static DFSCredentialsTuple dfsFromDescriptor(WithStorageProvider.StorageDescriptor descriptor, String newSubfolder, String oldSubfolder) {
        if (descriptor == null) {
            return null;
        }
        if (oldSubfolder == null) {
            oldSubfolder = "";
        }
        if (!oldSubfolder.startsWith("/")) {
            oldSubfolder = "/" + oldSubfolder;
        }
        if (newSubfolder == null) {
            newSubfolder = "";
        }
        if (!newSubfolder.startsWith("/")) {
            newSubfolder = "/" + newSubfolder;
        }
        switch (descriptor.getName()) {
            case FILESYSTEM: {
                log.info("uri:" + descriptor.getRootBucket());
                return new DFSCredentialsTuple((S061_DFSCredentials)S061_FilesystemDFSCredentials.builder().root(descriptor.getRootBucket() + oldSubfolder).build(), (S100_DFSCredentials)S100_FilesystemDFSCredentials.builder().root(descriptor.getRootBucket() + newSubfolder).build());
            }
            case MINIO: 
            case CEPH: 
            case AMAZON: {
                descriptor.getStorageService().get();
                log.info("uri       :" + descriptor.getLocation());
                log.info("accesskey :" + descriptor.getAccessKey());
                log.info("secretkey :" + descriptor.getSecretKey());
                log.info("region    :" + descriptor.getRegion());
                log.info("old rootbucket:" + descriptor.getRootBucket() + newSubfolder);
                log.info("new rootbucket:" + descriptor.getRootBucket() + oldSubfolder);
                log.info("mapped uri:" + descriptor.getMappedUrl());
                return new DFSCredentialsTuple((S061_DFSCredentials)S061_AmazonS3DFSCredentials.builder().accessKey(descriptor.getAccessKey()).secretKey(descriptor.getSecretKey()).region(descriptor.getRegion()).rootBucket(descriptor.getRootBucket() + oldSubfolder).url(descriptor.getMappedUrl()).build(), (S100_DFSCredentials)S100_AmazonS3DFSCredentials.builder().accessKey(descriptor.getAccessKey()).secretKey(descriptor.getSecretKey()).region(descriptor.getRegion()).rootBucket(descriptor.getRootBucket() + newSubfolder).url(descriptor.getMappedUrl()).build());
            }
        }
        throw new SimpleAdapterException("missing switch for " + (Object)((Object)descriptor.getName()));
    }

    private InitFromStorageProvider() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class DFSCredentialsTuple {
        private final S061_DFSCredentials oldVersion;
        private final S100_DFSCredentials newVersion;

        public DFSCredentialsTuple(S061_DFSCredentials oldVersion, S100_DFSCredentials newVersion) {
            this.oldVersion = oldVersion;
            this.newVersion = newVersion;
        }

        public S061_DFSCredentials getOldVersion() {
            return this.oldVersion;
        }

        public S100_DFSCredentials getNewVersion() {
            return this.newVersion;
        }
    }
}

