/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafemigration;

import de.adorsys.datasafe_0_6_1.encrypiton.api.types.S061_UserIDAuth;
import de.adorsys.datasafe_0_6_1.simple.adapter.api.S061_SimpleDatasafeService;
import de.adorsys.datasafe_0_6_1.simple.adapter.api.types.S061_DSDocument;
import de.adorsys.datasafe_0_6_1.simple.adapter.api.types.S061_DocumentFQN;
import de.adorsys.datasafe_0_6_1.simple.adapter.impl.S061_SimpleDatasafeServiceImpl;
import de.adorsys.datasafe_1_0_0.encrypiton.api.types.S100_UserID;
import de.adorsys.datasafe_1_0_0.encrypiton.api.types.S100_UserIDAuth;
import de.adorsys.datasafe_1_0_0.encrypiton.api.types.encryption.MutableEncryptionConfig;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.S100_SimpleDatasafeService;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.types.S100_DSDocument;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.types.S100_DocumentDirectoryFQN;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.types.S100_DocumentFQN;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.types.S100_ListRecursiveFlag;
import de.adorsys.datasafe_1_0_0.simple.adapter.impl.S100_SimpleDatasafeServiceImpl;
import de.adorsys.datasafe_1_0_0.types.api.types.S100_ReadKeyPassword;
import de.adorsys.datasafemigration.CreateStructureUtil;
import de.adorsys.datasafemigration.LoadStructureUtil;
import de.adorsys.datasafemigration.common.SwitchVersion;
import de.adorsys.datasafemigration.docker.InitFromStorageProvider;
import de.adorsys.datasafemigration.docker.WithStorageProvider;
import de.adorsys.datasafemigration.withDFSonly.LoadUserOldToNewFormat;
import de.adorsys.datasafemigration.withlocalfilesystem.LoadNewUserToLocal;
import de.adorsys.datasafemigration.withlocalfilesystem.WriteOldUserFromLocal;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationTest
extends WithStorageProvider {
    private static final Logger log = LoggerFactory.getLogger(MigrationTest.class);
    private Path tempDir;
    private String oldSubFolder = "0.6.1";
    private String newSubFolder = "1.0.0";

    @BeforeEach
    public void init() {
        this.tempDir = Files.createTempDirectory("migration-test", new FileAttribute[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"allStorages"})
    public void testMigrationWithLocalFiles(WithStorageProvider.StorageDescriptor descriptor) {
        InitFromStorageProvider.DFSCredentialsTuple dfsCredentialsTuple = InitFromStorageProvider.dfsFromDescriptor(descriptor, this.oldSubFolder, this.newSubFolder);
        S100_UserIDAuth userIDAuth = new S100_UserIDAuth(new S100_UserID("peter"), new S100_ReadKeyPassword("password"::toCharArray));
        S061_SimpleDatasafeServiceImpl oldService = new S061_SimpleDatasafeServiceImpl(dfsCredentialsTuple.getOldVersion());
        S100_SimpleDatasafeServiceImpl newService = new S100_SimpleDatasafeServiceImpl(dfsCredentialsTuple.getNewVersion(), new MutableEncryptionConfig());
        S100_DocumentDirectoryFQN startDatadir = new S100_DocumentDirectoryFQN(this.tempDir.toString()).addDirectory("startupfiles");
        MigrationTest.createLocalFilesInFolder(startDatadir.addDirectory(userIDAuth.getUserID().getValue()), 3, 3, 2, 1000);
        WriteOldUserFromLocal oldWriter = new WriteOldUserFromLocal((S061_SimpleDatasafeService)oldService, startDatadir);
        oldWriter.migrateUser(userIDAuth);
        LoadUserOldToNewFormat migrator = new LoadUserOldToNewFormat((S061_SimpleDatasafeService)oldService, (S100_SimpleDatasafeService)newService);
        migrator.migrateUser(userIDAuth);
        S100_DocumentDirectoryFQN destDatadir = new S100_DocumentDirectoryFQN(this.tempDir.toString()).addDirectory("loadedfromnewfiles");
        LoadNewUserToLocal loadNewUserToLocal = new LoadNewUserToLocal((S100_SimpleDatasafeService)newService, destDatadir);
        loadNewUserToLocal.migrateUser(userIDAuth);
        this.compare(startDatadir, destDatadir);
    }

    @ParameterizedTest
    @MethodSource(value={"allStorages"})
    public void testMigrationWithMemory(WithStorageProvider.StorageDescriptor descriptor) {
        InitFromStorageProvider.DFSCredentialsTuple dfsCredentialsTuple = InitFromStorageProvider.dfsFromDescriptor(descriptor, this.oldSubFolder, this.newSubFolder);
        Set<S061_UserIDAuth> listOfOldUsers = CreateStructureUtil.getS061_userIDAuths();
        HashSet<S100_UserIDAuth> listOfNewUsers = new HashSet<S100_UserIDAuth>();
        listOfOldUsers.forEach(s061_userIDAuth -> listOfNewUsers.add(SwitchVersion.to_1_0_0((S061_UserIDAuth)s061_userIDAuth)));
        S061_SimpleDatasafeServiceImpl s061_simpleDatasafeService = new S061_SimpleDatasafeServiceImpl(dfsCredentialsTuple.getOldVersion());
        S100_SimpleDatasafeServiceImpl s100_simpleDatasafeService = new S100_SimpleDatasafeServiceImpl(dfsCredentialsTuple.getNewVersion(), new MutableEncryptionConfig());
        Map<S061_UserIDAuth, Set<S061_DSDocument>> s061StructureMap = CreateStructureUtil.create061Structure((S061_SimpleDatasafeService)s061_simpleDatasafeService, listOfOldUsers);
        for (S100_UserIDAuth s100_userIDAuth : listOfNewUsers) {
            LoadUserOldToNewFormat migrator = new LoadUserOldToNewFormat((S061_SimpleDatasafeService)s061_simpleDatasafeService, (S100_SimpleDatasafeService)s100_simpleDatasafeService);
            migrator.migrateUser(s100_userIDAuth);
        }
        Map<S100_UserIDAuth, Set<S100_DSDocument>> s100_Structuremap = LoadStructureUtil.loadS100Structure((S100_SimpleDatasafeService)s100_simpleDatasafeService, listOfNewUsers);
        for (S061_UserIDAuth s061_userIDAuth2 : listOfOldUsers) {
            Set<S061_DSDocument> s061_dsDocuments = s061StructureMap.get(s061_userIDAuth2);
            Set<S100_DSDocument> s100_dsDocuments = s100_Structuremap.get(SwitchVersion.to_1_0_0((S061_UserIDAuth)s061_userIDAuth2));
            this.compare(s061_dsDocuments, s100_dsDocuments);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"allStorages"})
    public void testIncompatibility(WithStorageProvider.StorageDescriptor descriptor) {
        InitFromStorageProvider.DFSCredentialsTuple dfsCredentialsTuple = InitFromStorageProvider.dfsFromDescriptor(descriptor, this.oldSubFolder, this.oldSubFolder);
        S100_UserIDAuth userIDAuth = new S100_UserIDAuth(new S100_UserID("peter"), new S100_ReadKeyPassword("password"::toCharArray));
        S061_SimpleDatasafeServiceImpl oldService = new S061_SimpleDatasafeServiceImpl(dfsCredentialsTuple.getOldVersion());
        S100_DocumentDirectoryFQN startDatadir = new S100_DocumentDirectoryFQN(this.tempDir.toString()).addDirectory("startupfiles");
        MigrationTest.createLocalFilesInFolder(startDatadir.addDirectory(userIDAuth.getUserID().getValue()), 3, 3, 2, 1000);
        WriteOldUserFromLocal oldWriter = new WriteOldUserFromLocal((S061_SimpleDatasafeService)oldService, startDatadir);
        oldWriter.migrateUser(userIDAuth);
        S100_SimpleDatasafeServiceImpl newService = new S100_SimpleDatasafeServiceImpl(dfsCredentialsTuple.getNewVersion(), new MutableEncryptionConfig());
        Assertions.assertThrows(IOException.class, () -> MigrationTest.lambda$testIncompatibility$1((S100_SimpleDatasafeService)newService, userIDAuth));
    }

    private void compare(Set<S061_DSDocument> s061_dsDocuments, Set<S100_DSDocument> s100_dsDocuments) {
        int counter = 0;
        long bytecounter = 0L;
        for (S061_DSDocument s061_dsDocument : s061_dsDocuments) {
            S061_DocumentFQN s061_dsDocumentDocumentFQN = s061_dsDocument.getDocumentFQN();
            boolean documentFound = false;
            for (S100_DSDocument s100_dsDocument : s100_dsDocuments) {
                if (!SwitchVersion.to_0_6_1((S100_DocumentFQN)s100_dsDocument.getDocumentFQN()).equals((Object)s061_dsDocumentDocumentFQN)) continue;
                Assertions.assertArrayEquals((byte[])s061_dsDocument.getDocumentContent().getValue(), (byte[])s100_dsDocument.getDocumentContent().getValue());
                documentFound = true;
                ++counter;
                bytecounter += (long)s061_dsDocument.getDocumentContent().getValue().length;
            }
            if (documentFound) continue;
            throw new RuntimeException("Did not find document " + s061_dsDocumentDocumentFQN);
        }
        log.info("successfully compared {} documents with {} bytes in total", (Object)counter, (Object)bytecounter);
    }

    private void compare(S100_DocumentDirectoryFQN srcFolder, S100_DocumentDirectoryFQN destFolder) {
        List<String> destList;
        List<String> srcList;
        try (Stream<Path> srcWalk = Files.walk(Paths.get(srcFolder.getDocusafePath(), new String[0]), new FileVisitOption[0]);){
            srcList = srcWalk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(x -> x.toString()).collect(Collectors.toList());
        }
        try (Stream<Path> srcWalk = Files.walk(Paths.get(destFolder.getDocusafePath(), new String[0]), new FileVisitOption[0]);){
            destList = srcWalk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(x -> x.toString()).collect(Collectors.toList());
        }
        ArrayList pathOnlyListFromSrc = new ArrayList();
        srcList.forEach(el -> pathOnlyListFromSrc.add(el.substring(srcFolder.getDocusafePath().length() + 1)));
        ArrayList pathOnlyListFromDest = new ArrayList();
        destList.forEach(el -> pathOnlyListFromDest.add(el.substring(destFolder.getDocusafePath().length() + 1)));
        Assertions.assertEquals(pathOnlyListFromSrc, pathOnlyListFromDest);
        int counter = 0;
        for (String el2 : pathOnlyListFromSrc) {
            S100_DocumentFQN srcFQN = srcFolder.addName(el2);
            S100_DocumentFQN destFQN = destFolder.addName(el2);
            byte[] srcBytes = Files.readAllBytes(Paths.get(srcFQN.getDocusafePath(), new String[0]));
            byte[] destBytes = Files.readAllBytes(Paths.get(destFQN.getDocusafePath(), new String[0]));
            Assertions.assertArrayEquals((byte[])srcBytes, (byte[])destBytes);
            ++counter;
        }
        log.info("all {} files have same content :-)", (Object)counter);
    }

    private static void createLocalFilesInFolder(S100_DocumentDirectoryFQN path, int recursiveDepth, int numberOfFiles, int numberOfSubdirs, int sizeOfFile) {
        int i;
        if (recursiveDepth == 0) {
            return;
        }
        for (i = 0; i < numberOfFiles; ++i) {
            Path localFileToWrite = Paths.get(path.addName("File_" + i).getDocusafePath(), new String[0]);
            log.debug("create file " + localFileToWrite);
            Files.createDirectories(localFileToWrite.getParent(), new FileAttribute[0]);
            Files.write(localFileToWrite, MigrationTest.createDocumentContent(sizeOfFile), new OpenOption[0]);
        }
        for (i = 0; i < numberOfSubdirs; ++i) {
            MigrationTest.createLocalFilesInFolder(path.addDirectory("SUBDIR_" + i), recursiveDepth - 1, numberOfFiles, numberOfSubdirs, sizeOfFile);
        }
    }

    public static byte[] createDocumentContent(int sizeOfDocument) {
        byte[] bytes = new byte[sizeOfDocument];
        new Random().nextBytes(bytes);
        return bytes;
    }

    private static /* synthetic */ void lambda$testIncompatibility$1(S100_SimpleDatasafeService newService, S100_UserIDAuth userIDAuth) throws Throwable {
        newService.list(userIDAuth, new S100_DocumentDirectoryFQN("/"), S100_ListRecursiveFlag.TRUE);
    }
}

