/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafemigration.lockprovider;

import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedLocker {
    private static final Logger log = LoggerFactory.getLogger(DistributedLocker.class);
    private final LockProvider lockProvider;
    private Map<String, SimpleLock> lockmap = new HashMap<String, SimpleLock>();

    public DistributedLocker(LockProvider lockProvider) {
        this.lockProvider = lockProvider;
    }

    public boolean lockOrFail(String nameToLock, int milliSecondsToLock) {
        LockConfiguration lc = new LockConfiguration(nameToLock, Instant.now().plus(Duration.ofMillis(milliSecondsToLock)));
        Optional lock = this.lockProvider.lock(lc);
        if (lock.isPresent()) {
            this.lockmap.put(nameToLock, (SimpleLock)lock.get());
            log.debug("successfully locked {}", (Object)nameToLock);
            return true;
        }
        log.debug("failed to lock {}", (Object)nameToLock);
        return false;
    }

    public void unlock(String nameToLock) {
        SimpleLock simpleLock = this.lockmap.get(nameToLock);
        this.lockmap.remove(nameToLock);
        simpleLock.unlock();
        log.debug("successfully unlocked {}", (Object)nameToLock);
    }
}

