/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafemigration;

import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.simple.adapter.api.types.DSDocument;
import de.adorsys.datasafe.simple.adapter.api.types.DocumentContent;
import de.adorsys.datasafe.simple.adapter.api.types.DocumentFQN;
import de.adorsys.datasafe.simple.adapter.impl.GetStorage;
import de.adorsys.datasafe_0_6_1.simple.adapter.api.S061_SimpleDatasafeService;
import de.adorsys.datasafe_0_6_1.simple.adapter.api.types.S061_DFSCredentials;
import de.adorsys.datasafe_0_6_1.simple.adapter.impl.S061_SimpleDatasafeServiceImpl;
import de.adorsys.datasafe_1_0_1.encrypiton.api.types.encryption.MutableEncryptionConfig;
import de.adorsys.datasafe_1_0_1.simple.adapter.api.S101_SimpleDatasafeService;
import de.adorsys.datasafe_1_0_1.simple.adapter.api.types.S101_DFSCredentials;
import de.adorsys.datasafe_1_0_1.simple.adapter.impl.LogStringFrame;
import de.adorsys.datasafe_1_0_1.simple.adapter.impl.S101_SimpleDatasafeServiceImpl;
import de.adorsys.datasafemigration.DirectDFSAccess;
import de.adorsys.datasafemigration.ExtendedSwitchVersion;
import de.adorsys.datasafemigration.MigrationException;
import de.adorsys.datasafemigration.ModifyDFSCredentials;
import de.adorsys.datasafemigration.lockprovider.DistributedLocker;
import de.adorsys.datasafemigration.withDFSonly.LoadUserOldToNewFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import net.javacrumbs.shedlock.core.LockProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationLogic {
    private static final Logger log = LoggerFactory.getLogger(MigrationLogic.class);
    private final int timeout;
    private Set<String> migratedUsers = new HashSet<String>();
    private static DocumentFQN MIGRATION_CONFIRMATION = new DocumentFQN("DATASAFE_FORMAT_1_0_1");
    private final DistributedLocker distributedLocker;
    private final GetStorage.SystemRootAndStorageService oldStorage;
    private final GetStorage.SystemRootAndStorageService newStorage;
    private final GetStorage.SystemRootAndStorageService finalStorage;
    private final S061_SimpleDatasafeService oldService;
    private final S101_SimpleDatasafeService newService;
    private final boolean withIntermediateFolder;
    private final boolean migrationPossible;

    public MigrationLogic(LockProvider lockProvider, int timeout, S061_DFSCredentials oldDFS, S101_DFSCredentials newDFS, MutableEncryptionConfig mutableEncryptionConfig) {
        LogStringFrame lsf = new LogStringFrame();
        if (lockProvider != null) {
            this.timeout = timeout;
            this.distributedLocker = new DistributedLocker(lockProvider);
            this.migrationPossible = true;
            String oldRoot = ModifyDFSCredentials.getCurrentRootPath(ExtendedSwitchVersion.to_1_0_1(oldDFS));
            String newRoot = ModifyDFSCredentials.getCurrentRootPath(newDFS);
            this.withIntermediateFolder = oldRoot.equalsIgnoreCase(newRoot);
            if (this.withIntermediateFolder) {
                newDFS = ModifyDFSCredentials.appendToRootPath(newDFS, "tempForMigrationTo100");
            }
            this.oldService = new S061_SimpleDatasafeServiceImpl(oldDFS);
            this.newService = new S101_SimpleDatasafeServiceImpl(newDFS, mutableEncryptionConfig);
            this.finalStorage = this.withIntermediateFolder ? GetStorage.get(ExtendedSwitchVersion.to_1_0_1(oldDFS)) : null;
            this.oldStorage = GetStorage.get(ExtendedSwitchVersion.to_1_0_1(oldDFS));
            this.newStorage = GetStorage.get(newDFS);
            lsf.add("MigrationLogic      : ENABLED");
            lsf.add("  migration timeout : " + timeout);
            lsf.add("intermediate folder : " + (this.withIntermediateFolder ? "YES" : "NO"));
            lsf.add("           old root : " + this.oldStorage.getSystemRoot());
            if (this.withIntermediateFolder) {
                lsf.add("  intermediate root : " + this.newStorage.getSystemRoot());
                lsf.add("           new root : " + this.finalStorage.getSystemRoot());
            } else {
                lsf.add("           new root : " + this.newStorage.getSystemRoot());
            }
        } else {
            this.timeout = 0;
            this.oldStorage = null;
            this.newStorage = null;
            this.finalStorage = null;
            this.oldService = null;
            this.newService = null;
            this.withIntermediateFolder = false;
            this.distributedLocker = null;
            this.migrationPossible = false;
            lsf.add("MigrationLogic      : DISABLED");
        }
        log.info(lsf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkMigration(UserIDAuth userIDAuth) {
        int waitedInMillis;
        String username;
        block20: {
            if (!this.migrationPossible) {
                return false;
            }
            username = userIDAuth.getUserID().getValue();
            if (this.migratedUsers.contains(username)) {
                return true;
            }
            if (this.withIntermediateFolder) {
                if (DirectDFSAccess.doesDocumentExistInUsersRootDir(this.finalStorage, userIDAuth.getUserID(), MIGRATION_CONFIRMATION)) {
                    log.debug("user {} is already migrated, found version file in finalStorage", (Object)username);
                    this.migratedUsers.add(username);
                    return true;
                }
            } else if (DirectDFSAccess.doesDocumentExistInUsersRootDir(this.newStorage, userIDAuth.getUserID(), MIGRATION_CONFIRMATION)) {
                log.debug("user {} is already migrated, found version file in newStorage", (Object)username);
                this.migratedUsers.add(username);
                return true;
            }
            boolean gotALock = false;
            log.debug("check migration for {} not in cache yet", (Object)username);
            gotALock = this.distributedLocker.lockOrFail(username, this.timeout);
            if (!gotALock) {
                log.debug("as another thread/server seems to be busy with the migration of {}, we now wait at most {} millisecs", (Object)username, (Object)this.timeout);
                break block20;
            } else {
                log.debug("check migration does block now for {}", (Object)username);
                if (this.physicallyCheckMigrationWasDoneSuccessfully(userIDAuth.getUserID())) {
                    log.debug("migration for {} was already done, or user did not exist", (Object)username);
                    this.migratedUsers.add(username);
                    boolean bl = true;
                    return bl;
                }
                this.migrateUser(userIDAuth);
                this.migratedUsers.add(username);
                boolean bl = true;
                return bl;
            }
            finally {
                if (gotALock) {
                    this.distributedLocker.unlock(username);
                    log.debug("check migration was unblocked for {}", (Object)username);
                }
            }
        }
        for (waitedInMillis = 0; waitedInMillis < this.timeout; waitedInMillis += 500) {
            Thread.currentThread();
            Thread.sleep(500L);
            if (!this.physicallyCheckMigrationWasDoneSuccessfully(userIDAuth.getUserID())) continue;
            log.debug("another thread successfully migrated user {} in the meantime", (Object)username);
            this.migratedUsers.add(username);
            boolean bl = true;
            return bl;
        }
        if (!this.physicallyCheckMigrationWasDoneSuccessfully(userIDAuth.getUserID())) {
            throw new MigrationException("we have waited " + waitedInMillis + " millisecs, but migration is not finished yet, what shall we do?");
        }
        log.debug("another thread successfully migrated user {} in the meantime", (Object)username);
        this.migratedUsers.add(username);
        boolean bl = true;
        return bl;
    }

    public void createFileForNewUser(UserIDAuth userIDAuth) {
        if (!this.migrationPossible) {
            throw new MigrationException("create new File must not be called if migration is not enabled");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("user created (without migration at :").append(new Date().toString()).append("\n");
        DSDocument dsDocument = new DSDocument(MIGRATION_CONFIRMATION, new DocumentContent(sb.toString().getBytes()));
        if (this.withIntermediateFolder) {
            DirectDFSAccess.storeFileInUsersRootDir(this.finalStorage, userIDAuth.getUserID(), dsDocument);
        } else {
            DirectDFSAccess.storeFileInUsersRootDir(this.newStorage, userIDAuth.getUserID(), dsDocument);
        }
    }

    private void migrateUser(UserIDAuth userIDAuth) {
        if (this.newService.userExists(userIDAuth.getUserID().getReal())) {
            throw new MigrationException("user " + userIDAuth.getUserID().getValue() + " already exists in migrated dfs, but is not yet migrated");
        }
        log.debug("NOW MIGRATION OF USER {} IS STARTED", (Object)userIDAuth.getUserID().getValue());
        Instant start = Instant.now();
        LoadUserOldToNewFormat.MigrationInfo migrationInfo = new LoadUserOldToNewFormat(this.oldService, this.newService).migrateUser(userIDAuth.getReal());
        log.info(migrationInfo.toString());
        DSDocument dsDocument = new DSDocument(MIGRATION_CONFIRMATION, new DocumentContent(migrationInfo.toString().getBytes()));
        DirectDFSAccess.storeFileInUsersRootDir(this.newStorage, userIDAuth.getUserID(), dsDocument);
        DirectDFSAccess.MoveInfo moveInfo = null;
        if (this.withIntermediateFolder) {
            moveInfo = this.moveFromIntermediateToFinal(userIDAuth);
        } else {
            int destroyedInOld = DirectDFSAccess.destroyAllFileInUsersRootDir(this.oldStorage, userIDAuth.getUserID());
            log.debug("destroyed user in old location. deleted {} files.", (Object)destroyedInOld);
        }
        Duration totalTimeOfMigration = Duration.between(start, Instant.now());
        log.debug("NOW MIGRATION OF USER {} IS FINISHED", (Object)userIDAuth.getUserID().getValue());
        long totalMillis = totalTimeOfMigration.toMillis();
        long migrationMillis = migrationInfo.getDuration().toMillis();
        long filemovementMillis = totalMillis - migrationMillis;
        log.info("MIGRATION OF {} FILES FOR USER {} TOOK {} MILLIS. Migration itself took {} millis and relocation of files took {} millis.", new Object[]{migrationInfo.getFiles(), userIDAuth.getUserID().getValue(), totalMillis, migrationMillis, filemovementMillis});
    }

    private boolean physicallyCheckMigrationWasDoneSuccessfully(UserID userID) {
        if (this.withIntermediateFolder) {
            if (DirectDFSAccess.doesDocumentExistInUsersRootDir(this.finalStorage, userID, MIGRATION_CONFIRMATION)) {
                log.debug("user {} is already migrated");
                return true;
            }
            if (!DirectDFSAccess.doesUserExist(this.finalStorage, userID)) {
                log.debug("user {} does not exist at all and thus is to be regarded as migrated");
                return true;
            }
            log.debug("user {} is not yet migrated", (Object)userID);
            return false;
        }
        if (DirectDFSAccess.doesDocumentExistInUsersRootDir(this.newStorage, userID, MIGRATION_CONFIRMATION)) {
            log.debug("user {} is already migrated");
            return true;
        }
        if (!DirectDFSAccess.doesUserExist(this.oldStorage, userID)) {
            log.debug("user {} does not exist at all and thus is to be regarded as migrated");
            return true;
        }
        log.debug("user {} is not yet migrated", (Object)userID);
        return false;
    }

    private DirectDFSAccess.MoveInfo moveFromIntermediateToFinal(UserIDAuth userIDAuth) {
        int destroyedInOld = DirectDFSAccess.destroyAllFileInUsersRootDir(this.oldStorage, userIDAuth.getUserID());
        DirectDFSAccess.MoveInfo moveInfo = DirectDFSAccess.moveAllFiles(this.newStorage, this.oldStorage, userIDAuth.getUserID());
        int destroyedInNew = DirectDFSAccess.destroyAllFileInUsersRootDir(this.newStorage, userIDAuth.getUserID());
        log.info("destroyed {} files in old format of user {} ", (Object)destroyedInOld, (Object)userIDAuth.getUserID().getValue());
        log.info("moveinfo {} for user {}", (Object)moveInfo.toString(), (Object)userIDAuth.getUserID().getValue());
        log.info("destroyed {} files in new format of user {} ", (Object)destroyedInNew, (Object)userIDAuth.getUserID().getValue());
        return moveInfo;
    }
}

