/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.simple.adapter.spring.factory;

import de.adorsys.datasafe.simple.adapter.api.SimpleDatasafeService;
import de.adorsys.datasafe.simple.adapter.api.exceptions.SimpleAdapterException;
import de.adorsys.datasafe.simple.adapter.impl.DatasafeMigrationConfig;
import de.adorsys.datasafe.simple.adapter.impl.SimpleDatasafeServiceWithMigration;
import de.adorsys.datasafe_1_0_1.encrypiton.api.types.encryption.MutableEncryptionConfig;
import de.adorsys.datasafe_1_0_1.simple.adapter.api.types.S101_AmazonS3DFSCredentials;
import de.adorsys.datasafe_1_0_1.simple.adapter.api.types.S101_DFSCredentials;
import de.adorsys.datasafe_1_0_1.simple.adapter.api.types.S101_FilesystemDFSCredentials;
import de.adorsys.datasafe_1_0_1.simple.adapter.spring.properties.SpringDatasafeEncryptionProperties;
import de.adorsys.datasafemigration.MigrationException;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SpringSimpleDatasafeServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(SpringSimpleDatasafeServiceFactory.class);
    @Autowired
    S101_DFSCredentials wiredDfsCredentials;
    @Autowired
    SpringDatasafeEncryptionProperties encryptionProperties;
    @Autowired
    DatasafeMigrationConfig datasafeMigrationConfig;
    S101_DFSCredentials dfsCredentials;
    boolean useWiredCredentials = true;

    @PostConstruct
    public void postConstruct() {
        log.info("POST CONSTRUCT OF SpringSimpleDatasafeServiceFactory");
        if (this.useWiredCredentials) {
            if (this.wiredDfsCredentials == null) {
                throw new RuntimeException("wiredDfsCredentials are nulL, so injection did not work");
            }
            this.dfsCredentials = this.wiredDfsCredentials;
        }
        if (this.datasafeMigrationConfig == null) {
            throw new MigrationException("Injection for LockProvider did not work");
        }
    }

    public SpringSimpleDatasafeServiceFactory() {
        this.useWiredCredentials = true;
    }

    public SpringSimpleDatasafeServiceFactory(S101_DFSCredentials credentials) {
        if (credentials == null) {
            throw new RuntimeException("dfs credentials passed in must not be null");
        }
        this.dfsCredentials = credentials;
        this.useWiredCredentials = false;
        log.info("CTOR of SpringSimpleDatasafeServiceFactory");
    }

    public SimpleDatasafeService getSimpleDataSafeServiceWithSubdir(String subdirBelowRoot) {
        if (this.dfsCredentials instanceof S101_AmazonS3DFSCredentials) {
            S101_AmazonS3DFSCredentials amazonS3DFSCredentials = (S101_AmazonS3DFSCredentials)this.dfsCredentials;
            return new SimpleDatasafeServiceWithMigration(this.datasafeMigrationConfig, (S101_DFSCredentials)amazonS3DFSCredentials.toBuilder().rootBucket(amazonS3DFSCredentials.getRootBucket() + "/" + subdirBelowRoot).build(), null != this.encryptionProperties ? this.encryptionProperties.getEncryption() : new MutableEncryptionConfig());
        }
        if (this.dfsCredentials instanceof S101_FilesystemDFSCredentials) {
            S101_FilesystemDFSCredentials filesystemDFSCredentials = (S101_FilesystemDFSCredentials)this.dfsCredentials;
            return new SimpleDatasafeServiceWithMigration(this.datasafeMigrationConfig, (S101_DFSCredentials)filesystemDFSCredentials.toBuilder().root(filesystemDFSCredentials.getRoot() + "/" + subdirBelowRoot).build(), null != this.encryptionProperties ? this.encryptionProperties.getEncryption() : new MutableEncryptionConfig());
        }
        throw new SimpleAdapterException("missing switch for DFSCredentials" + this.dfsCredentials);
    }
}

