/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.simple.adapter.spring.datasource;

import de.adorsys.datasafe.simple.adapter.spring.properties.SpringPostgresDatasourceProperties;
import javax.sql.DataSource;
import org.postgresql.ds.PGSimpleDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class WithPostgresDataSource {
    private static final Logger log = LoggerFactory.getLogger(WithPostgresDataSource.class);
    private static String createTable = "CREATE TABLE IF NOT EXISTS shedlock(name VARCHAR(64), lock_until TIMESTAMP, locked_at TIMESTAMP, locked_by  VARCHAR(255), PRIMARY KEY (name))";

    public static DataSource get(SpringPostgresDatasourceProperties props) {
        Class.forName("org.postgresql.Driver");
        PGSimpleDataSource datasource = new PGSimpleDataSource();
        log.debug("set url to postgres connection");
        log.info("{}", (Object)props.toString());
        datasource.setUrl(props.getUrl());
        datasource.setUser(props.getUsername());
        datasource.setPassword(props.getPassword());
        JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)datasource);
        jdbcTemplate.execute(createTable);
        return datasource;
    }
}

