/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.simple.adapter.impl;

import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.simple.adapter.api.SimpleDatasafeService;
import de.adorsys.datasafe.simple.adapter.api.types.DSDocument;
import de.adorsys.datasafe.simple.adapter.api.types.DSDocumentStream;
import de.adorsys.datasafe.simple.adapter.api.types.DocumentDirectoryFQN;
import de.adorsys.datasafe.simple.adapter.api.types.DocumentFQN;
import de.adorsys.datasafe.simple.adapter.api.types.ListRecursiveFlag;
import de.adorsys.datasafe.simple.adapter.impl.DatasafeMigrationConfig;
import de.adorsys.datasafe.types.api.types.ReadKeyPassword;
import de.adorsys.datasafe_0_6_1.encrypiton.api.types.S061_UserID;
import de.adorsys.datasafe_0_6_1.simple.adapter.api.S061_SimpleDatasafeService;
import de.adorsys.datasafe_0_6_1.simple.adapter.api.types.S061_DFSCredentials;
import de.adorsys.datasafe_0_6_1.simple.adapter.impl.S061_SimpleDatasafeServiceImpl;
import de.adorsys.datasafe_1_0_1.encrypiton.api.types.S101_UserIDAuth;
import de.adorsys.datasafe_1_0_1.encrypiton.api.types.encryption.MutableEncryptionConfig;
import de.adorsys.datasafe_1_0_1.simple.adapter.api.S101_SimpleDatasafeService;
import de.adorsys.datasafe_1_0_1.simple.adapter.api.types.S101_DFSCredentials;
import de.adorsys.datasafe_1_0_1.simple.adapter.api.types.S101_DocumentDirectoryFQN;
import de.adorsys.datasafe_1_0_1.simple.adapter.impl.S101_SimpleDatasafeServiceImpl;
import de.adorsys.datasafemigration.ExtendedSwitchVersion;
import de.adorsys.datasafemigration.MigrationLogic;
import de.adorsys.datasafemigration.ModifyDFSCredentials;
import de.adorsys.datasafemigration.common.SwitchVersion;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDatasafeServiceWithMigration
implements SimpleDatasafeService {
    private static final Logger log = LoggerFactory.getLogger(SimpleDatasafeServiceWithMigration.class);
    private S101_SimpleDatasafeService newReal;
    private S061_SimpleDatasafeService oldReal;
    private MigrationLogic migrationLogic;
    private final S061_DFSCredentials credentialsToNOTMigratedData;
    private final S101_DFSCredentials credentialsToMigratedData;

    public SimpleDatasafeServiceWithMigration(DatasafeMigrationConfig datasafeMigrationConfig, S101_DFSCredentials dfsCredentials, MutableEncryptionConfig mutableEncryptionConfig) {
        this.credentialsToNOTMigratedData = ExtendedSwitchVersion.to_0_6_1(dfsCredentials);
        this.credentialsToMigratedData = datasafeMigrationConfig.isDistinctFolder() ? ModifyDFSCredentials.getPathToMigratedData(dfsCredentials) : dfsCredentials;
        this.oldReal = new S061_SimpleDatasafeServiceImpl(this.credentialsToNOTMigratedData);
        this.newReal = new S101_SimpleDatasafeServiceImpl(this.credentialsToMigratedData, mutableEncryptionConfig);
        this.migrationLogic = new MigrationLogic(datasafeMigrationConfig.getLockProvider(), datasafeMigrationConfig.getMigrationtimeout(), this.credentialsToNOTMigratedData, this.credentialsToMigratedData, mutableEncryptionConfig);
    }

    public S061_DFSCredentials getCredentialsToNOTMigratedData() {
        return this.credentialsToNOTMigratedData;
    }

    public S101_DFSCredentials getCredentialsToMigratedData() {
        return this.credentialsToMigratedData;
    }

    @Override
    public void createUser(UserIDAuth userIDAuth) {
        if (this.checkMigration(userIDAuth)) {
            this.newReal.createUser(userIDAuth.getReal());
            this.migrationLogic.createFileForNewUser(userIDAuth);
            return;
        }
        this.oldReal.createUser(SwitchVersion.to_0_6_1((S101_UserIDAuth)userIDAuth.getReal()));
    }

    @Override
    public void destroyUser(UserIDAuth userIDAuth) {
        if (this.checkMigration(userIDAuth)) {
            this.newReal.destroyUser(userIDAuth.getReal());
            return;
        }
        this.oldReal.destroyUser(SwitchVersion.to_0_6_1((S101_UserIDAuth)userIDAuth.getReal()));
    }

    @Override
    public boolean userExists(UserID userID) {
        boolean result = false;
        if (this.oldReal != null) {
            try {
                result = this.oldReal.userExists(new S061_UserID(userID.getReal().getValue()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result) {
                return result;
            }
        }
        if (this.newReal != null) {
            return this.newReal.userExists(userID.getReal());
        }
        throw new RuntimeException("dont know what to do");
    }

    @Override
    public void storeDocument(UserIDAuth userIDAuth, DSDocument dsDocument) {
        if (this.checkMigration(userIDAuth)) {
            this.newReal.storeDocument(userIDAuth.getReal(), dsDocument.getReal());
            return;
        }
        this.oldReal.storeDocument(SwitchVersion.to_0_6_1((S101_UserIDAuth)userIDAuth.getReal()), ExtendedSwitchVersion.to_0_6_1(dsDocument.getReal()));
    }

    @Override
    public DSDocument readDocument(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        if (this.checkMigration(userIDAuth)) {
            return ExtendedSwitchVersion.toCurrent(this.newReal.readDocument(userIDAuth.getReal(), documentFQN.getReal()));
        }
        return ExtendedSwitchVersion.toCurrent(this.oldReal.readDocument(SwitchVersion.to_0_6_1((S101_UserIDAuth)userIDAuth.getReal()), ExtendedSwitchVersion.to_0_6_1(documentFQN.getReal())));
    }

    @Override
    public OutputStream storeDocumentStream(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        if (this.checkMigration(userIDAuth)) {
            return this.newReal.storeDocumentStream(userIDAuth.getReal(), documentFQN.getReal());
        }
        return this.oldReal.storeDocumentStream(SwitchVersion.to_0_6_1((S101_UserIDAuth)userIDAuth.getReal()), ExtendedSwitchVersion.to_0_6_1(documentFQN.getReal()));
    }

    @Override
    public DSDocumentStream readDocumentStream(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        if (this.checkMigration(userIDAuth)) {
            return ExtendedSwitchVersion.toCurrent(this.newReal.readDocumentStream(userIDAuth.getReal(), documentFQN.getReal()));
        }
        return ExtendedSwitchVersion.toCurrent(this.oldReal.readDocumentStream(SwitchVersion.to_0_6_1((S101_UserIDAuth)userIDAuth.getReal()), ExtendedSwitchVersion.to_0_6_1(documentFQN.getReal())));
    }

    @Override
    public void storeDocumentStream(UserIDAuth userIDAuth, DSDocumentStream dsDocumentStream) {
        if (this.checkMigration(userIDAuth)) {
            this.newReal.storeDocumentStream(userIDAuth.getReal(), dsDocumentStream.getReal());
            return;
        }
        this.oldReal.storeDocumentStream(SwitchVersion.to_0_6_1((S101_UserIDAuth)userIDAuth.getReal()), ExtendedSwitchVersion.to_0_6_1(dsDocumentStream.getReal()));
    }

    @Override
    public void deleteDocument(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        if (this.checkMigration(userIDAuth)) {
            this.newReal.deleteDocument(userIDAuth.getReal(), documentFQN.getReal());
            return;
        }
        this.oldReal.deleteDocument(SwitchVersion.to_0_6_1((S101_UserIDAuth)userIDAuth.getReal()), ExtendedSwitchVersion.to_0_6_1(documentFQN.getReal()));
    }

    @Override
    public boolean documentExists(UserIDAuth userIDAuth, DocumentFQN documentFQN) {
        if (this.checkMigration(userIDAuth)) {
            return this.newReal.documentExists(userIDAuth.getReal(), documentFQN.getReal());
        }
        return this.oldReal.documentExists(SwitchVersion.to_0_6_1((S101_UserIDAuth)userIDAuth.getReal()), ExtendedSwitchVersion.to_0_6_1(documentFQN.getReal()));
    }

    @Override
    public void deleteFolder(UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN) {
        if (this.checkMigration(userIDAuth)) {
            this.newReal.deleteFolder(userIDAuth.getReal(), documentDirectoryFQN.getReal());
            return;
        }
        this.oldReal.deleteFolder(SwitchVersion.to_0_6_1((S101_UserIDAuth)userIDAuth.getReal()), ExtendedSwitchVersion.to_0_6_1(documentDirectoryFQN.getReal()));
    }

    @Override
    public List<DocumentFQN> list(UserIDAuth userIDAuth, DocumentDirectoryFQN documentDirectoryFQN, ListRecursiveFlag listRecursiveFlag) {
        if (this.checkMigration(userIDAuth)) {
            ArrayList<DocumentFQN> result = new ArrayList<DocumentFQN>();
            this.newReal.list(userIDAuth.getReal(), documentDirectoryFQN.getReal(), ExtendedSwitchVersion.to_1_0_1(listRecursiveFlag)).forEach(el -> result.add(new DocumentFQN(el.getDocusafePath())));
            return result;
        }
        ArrayList<DocumentFQN> result = new ArrayList<DocumentFQN>();
        this.oldReal.list(SwitchVersion.to_0_6_1((S101_UserIDAuth)userIDAuth.getReal()), SwitchVersion.to_0_6_1((S101_DocumentDirectoryFQN)documentDirectoryFQN.getReal()), ExtendedSwitchVersion.to_0_6_1(listRecursiveFlag)).forEach(el -> result.add(new DocumentFQN(el.getDocusafePath())));
        return result;
    }

    @Override
    public void cleanupDb() {
        if (this.newReal != null) {
            this.newReal.cleanupDb();
        }
        if (this.oldReal != null) {
            this.oldReal.cleanupDb();
        }
    }

    @Override
    public void changeKeystorePassword(UserIDAuth userIDAuth, ReadKeyPassword readKeyPassword) {
        if (this.checkMigration(userIDAuth)) {
            this.newReal.changeKeystorePassword(userIDAuth.getReal(), readKeyPassword.getReal());
            return;
        }
        this.oldReal.changeKeystorePassword(SwitchVersion.to_0_6_1((S101_UserIDAuth)userIDAuth.getReal()), ExtendedSwitchVersion.to_0_6_1(readKeyPassword.getReal()));
    }

    private boolean checkMigration(UserIDAuth userIDAuth) {
        return this.migrationLogic.checkMigration(userIDAuth);
    }
}

