/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafemigration;

import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.simple.adapter.api.types.DSDocument;
import de.adorsys.datasafe.simple.adapter.api.types.DocumentFQN;
import de.adorsys.datasafe.simple.adapter.impl.GetStorage;
import de.adorsys.datasafe_1_0_0.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe_1_0_0.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe_1_0_0.types.api.resource.WithCallback;
import de.adorsys.datasafemigration.MigrationException;
import java.io.OutputStream;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectDFSAccess {
    private static final Logger log = LoggerFactory.getLogger(DirectDFSAccess.class);

    public static void storeFileInUsersRootDir(GetStorage.SystemRootAndStorageService storage, UserID userID, DSDocument document) {
        String root = DirectDFSAccess.getSystemRootDirOfUsers(storage.getSystemRoot(), userID);
        String wholePath = root + document.getDocumentFQN().getDatasafePath();
        log.debug("absolute location {}", (Object)wholePath);
        AbsoluteLocation abso = BasePrivateResource.forAbsolutePrivate((String)wholePath);
        try (OutputStream write = storage.getStorageService().write(WithCallback.noCallback((Object)abso));){
            write.write(document.getDocumentContent().getValue());
        }
    }

    public static int destroyAllFileInUsersRootDir(GetStorage.SystemRootAndStorageService source, UserID userID) {
        AtomicInteger numberOfFilesDestoyed = new AtomicInteger(0);
        String usersRoot = DirectDFSAccess.getSystemRootDirOfUsers(source.getSystemRoot(), userID);
        AbsoluteLocation sourceLocation = BasePrivateResource.forAbsolutePrivate((String)usersRoot);
        HashSet result = new HashSet();
        try (Stream list = source.getStorageService().list(sourceLocation);){
            list.forEach(el -> {
                source.getStorageService().remove(el);
                numberOfFilesDestoyed.incrementAndGet();
            });
        }
        return numberOfFilesDestoyed.get();
    }

    public static boolean doesDocumentExistInUsersRootDir(GetStorage.SystemRootAndStorageService source, UserID userID, DocumentFQN documentFQN) {
        String root = DirectDFSAccess.getSystemRootDirOfUsers(source.getSystemRoot(), userID);
        String wholePath = root + documentFQN.getDatasafePath();
        AbsoluteLocation sourceLocation = BasePrivateResource.forAbsolutePrivate((String)wholePath);
        return source.getStorageService().objectExists(sourceLocation);
    }

    public static MoveInfo moveAllFiles(GetStorage.SystemRootAndStorageService source, GetStorage.SystemRootAndStorageService dest, UserID userID) {
        MoveInfo mi = new MoveInfo();
        Instant start = Instant.now();
        String sourceRoot = DirectDFSAccess.getSystemRootDirOfUsers(source.getSystemRoot(), userID);
        AbsoluteLocation sourceLocation = BasePrivateResource.forAbsolutePrivate((String)sourceRoot);
        try (Stream list = source.getStorageService().list(sourceLocation);){
            list.forEach(el -> {
                mi.increaseFiles();
                String elString = el.location().asURI().toASCIIString();
                if (!elString.startsWith(sourceRoot)) {
                    throw new MigrationException("expected path " + elString + " to start with " + sourceRoot);
                }
                String relativePath = elString.substring(sourceRoot.length());
                mi.increaseBytes(DirectDFSAccess.moveSingleFile(source, dest, userID, relativePath));
            });
        }
        mi.setDuration(Duration.between(start, Instant.now()));
        return mi;
    }

    public static List<String> listAllFiles(GetStorage.SystemRootAndStorageService source) {
        String sourceRoot = DirectDFSAccess.getRootPathAsString(source.getSystemRoot());
        AbsoluteLocation sourceLocation = BasePrivateResource.forAbsolutePrivate((String)sourceRoot);
        ArrayList result = new ArrayList();
        try (Stream list = source.getStorageService().list(sourceLocation);){
            list.forEach(el -> result.add(el.location().asURI().toASCIIString()));
        }
        return result.stream().sorted().collect(Collectors.toList());
    }

    /*
     * Exception decompiling
     */
    private static long moveSingleFile(GetStorage.SystemRootAndStorageService source, GetStorage.SystemRootAndStorageService dest, UserID userID, String relativePath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String getSystemRootDirOfUsers(URI systemRoot, UserID userID) {
        String root = DirectDFSAccess.getRootPathAsString(systemRoot);
        return root + "users/" + userID.getValue() + "/";
    }

    private static String getRootPathAsString(URI systemRoot) {
        String root = systemRoot.toASCIIString();
        if (!root.endsWith("/")) {
            root = root + "/";
        }
        return root;
    }

    public static class MoveInfo {
        long bytes = 0L;
        long numberOfFiles = 0L;
        Duration duration = null;

        public void increaseFiles() {
            ++this.numberOfFiles;
        }

        public void increaseBytes(long inc) {
            this.bytes += inc;
        }

        public void setDuration(Duration d) {
            this.duration = d;
        }

        public String toString() {
            return "moved " + this.numberOfFiles + " file with in total " + this.bytes + " bytes in " + this.duration.toMillis() + " milliseconds";
        }

        public long getBytes() {
            return this.bytes;
        }

        public long getNumberOfFiles() {
            return this.numberOfFiles;
        }

        public Duration getDuration() {
            return this.duration;
        }
    }
}

