/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.simple.adapter.spring;

import de.adorsys.datasafe.simple.adapter.api.SimpleDatasafeService;
import de.adorsys.datasafe.simple.adapter.impl.DatasafeMigrationConfig;
import de.adorsys.datasafe.simple.adapter.spring.factory.SpringDatasafeMigrationConfigWrapperFactory;
import de.adorsys.datasafe.simple.adapter.spring.factory.SpringSimpleDatasafeServiceFactory;
import de.adorsys.datasafe.simple.adapter.spring.properties.SpringDatasafeMigrationProperties;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.types.S100_DFSCredentials;
import de.adorsys.datasafe_1_0_0.simple.adapter.spring.SpringPropertiesToDFSCredentialsUtil;
import de.adorsys.datasafe_1_0_0.simple.adapter.spring.properties.SpringAmazonS3DFSCredentialsProperties;
import de.adorsys.datasafe_1_0_0.simple.adapter.spring.properties.SpringDFSCredentialProperties;
import de.adorsys.datasafe_1_0_0.simple.adapter.spring.properties.SpringDatasafeEncryptionProperties;
import de.adorsys.datasafe_1_0_0.simple.adapter.spring.properties.SpringFilesystemDFSCredentialsProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SpringDFSCredentialProperties.class, SpringFilesystemDFSCredentialsProperties.class, SpringAmazonS3DFSCredentialsProperties.class, SpringDatasafeEncryptionProperties.class, SpringDatasafeMigrationProperties.class})
public class DatasafeSpringBeans {
    private static final Logger log = LoggerFactory.getLogger(DatasafeSpringBeans.class);

    public DatasafeSpringBeans() {
        log.info("INIT of DatasafeSpringBeans");
    }

    @Bean
    SpringSimpleDatasafeServiceFactory simpleDatasafeServiceFactory() {
        return new SpringSimpleDatasafeServiceFactory();
    }

    @Bean
    S100_DFSCredentials dfsCredentials(SpringDFSCredentialProperties properties) {
        return SpringPropertiesToDFSCredentialsUtil.dfsCredentials((SpringDFSCredentialProperties)properties);
    }

    @Bean
    public SimpleDatasafeService simpleDatasafeService(SpringSimpleDatasafeServiceFactory factory) {
        return factory.getSimpleDataSafeServiceWithSubdir("");
    }

    @Bean
    DatasafeMigrationConfig lockProviderForMigration(SpringDatasafeMigrationProperties springDatasafeMigrationProperties) {
        log.info("bean for lockprovider retrieved");
        return SpringDatasafeMigrationConfigWrapperFactory.getFromProperties(springDatasafeMigrationProperties);
    }
}

