/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.simple.adapter.impl;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.types.S100_AmazonS3DFSCredentials;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.types.S100_DFSCredentials;
import de.adorsys.datasafe_1_0_0.simple.adapter.api.types.S100_FilesystemDFSCredentials;
import de.adorsys.datasafe_1_0_0.storage.api.StorageService;
import de.adorsys.datasafe_1_0_0.storage.impl.fs.FileSystemStorageService;
import de.adorsys.datasafe_1_0_0.storage.impl.s3.S3StorageService;
import de.adorsys.datasafe_1_0_0.types.api.utils.ExecutorServiceUtil;
import de.adorsys.datasafemigration.MigrationException;
import java.net.URI;
import java.nio.file.FileSystems;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetStorage {
    private static final Logger log = LoggerFactory.getLogger(GetStorage.class);
    private static final String AMAZON_URL = "https://s3.amazonaws.com";
    private static final String S3_PREFIX = "s3://";

    public static SystemRootAndStorageService get(S100_DFSCredentials dfsCredentials) {
        if (dfsCredentials instanceof S100_FilesystemDFSCredentials) {
            return GetStorage.useFileSystem((S100_FilesystemDFSCredentials)dfsCredentials);
        }
        if (dfsCredentials instanceof S100_AmazonS3DFSCredentials) {
            return GetStorage.useAmazonS3((S100_AmazonS3DFSCredentials)dfsCredentials);
        }
        throw new MigrationException("dont know to get storage of " + dfsCredentials.getClass().getName());
    }

    private static SystemRootAndStorageService useAmazonS3(S100_AmazonS3DFSCredentials dfsCredentials) {
        AmazonS3 amazons3;
        boolean useEndpoint;
        S100_AmazonS3DFSCredentials amazonS3DFSCredentials = dfsCredentials;
        AmazonS3ClientBuilder amazonS3ClientBuilder = (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(amazonS3DFSCredentials.getAccessKey(), amazonS3DFSCredentials.getSecretKey())))).enablePathStyleAccess();
        boolean bl = useEndpoint = !amazonS3DFSCredentials.getUrl().equals(AMAZON_URL) && !amazonS3DFSCredentials.getUrl().startsWith(S3_PREFIX);
        if (useEndpoint) {
            AwsClientBuilder.EndpointConfiguration endpoint = new AwsClientBuilder.EndpointConfiguration(amazonS3DFSCredentials.getUrl(), amazonS3DFSCredentials.getRegion());
            amazonS3ClientBuilder.withEndpointConfiguration(endpoint);
        } else {
            amazonS3ClientBuilder.withRegion(amazonS3DFSCredentials.getRegion());
        }
        if (amazonS3DFSCredentials.isNoHttps()) {
            log.info("Creating S3 client without https");
            ClientConfiguration clientConfig = new ClientConfiguration();
            clientConfig.setProtocol(Protocol.HTTP);
            clientConfig.disableSocketProxy();
            amazonS3ClientBuilder.withClientConfiguration(clientConfig);
        }
        if (!(amazons3 = (AmazonS3)amazonS3ClientBuilder.build()).doesBucketExistV2(amazonS3DFSCredentials.getContainer())) {
            amazons3.createBucket(amazonS3DFSCredentials.getContainer());
        }
        S3StorageService storageService = new S3StorageService(amazons3, amazonS3DFSCredentials.getContainer(), ExecutorServiceUtil.submitterExecutesOnStarvationExecutingService((int)amazonS3DFSCredentials.getThreadPoolSize(), (int)amazonS3DFSCredentials.getQueueSize()));
        URI systemRoot = URI.create(S3_PREFIX + amazonS3DFSCredentials.getRootBucket());
        log.info("build DFS to S3 with root " + amazonS3DFSCredentials.getRootBucket() + " and url " + amazonS3DFSCredentials.getUrl());
        return new SystemRootAndStorageService(systemRoot, (StorageService)storageService);
    }

    private static SystemRootAndStorageService useFileSystem(S100_FilesystemDFSCredentials dfsCredentials) {
        S100_FilesystemDFSCredentials filesystemDFSCredentials = dfsCredentials;
        URI systemRoot = FileSystems.getDefault().getPath(filesystemDFSCredentials.getRoot(), new String[0]).toAbsolutePath().toUri();
        FileSystemStorageService storageService = new FileSystemStorageService(FileSystems.getDefault().getPath(filesystemDFSCredentials.getRoot(), new String[0]));
        log.info("build DFS to FILESYSTEM with root " + filesystemDFSCredentials.getRoot());
        return new SystemRootAndStorageService(systemRoot, (StorageService)storageService);
    }

    public static class SystemRootAndStorageService {
        private final URI systemRoot;
        private final StorageService storageService;

        public SystemRootAndStorageService(URI systemRoot, StorageService storageService) {
            this.systemRoot = systemRoot;
            this.storageService = storageService;
        }

        public URI getSystemRoot() {
            return this.systemRoot;
        }

        public StorageService getStorageService() {
            return this.storageService;
        }
    }
}

