package de.adorsys.datasafe.metainfo.version.impl.version.latest;

import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.metainfo.version.api.actions.VersionedList;
import de.adorsys.datasafe.metainfo.version.api.actions.VersionedRead;
import de.adorsys.datasafe.metainfo.version.api.actions.VersionedRemove;
import de.adorsys.datasafe.metainfo.version.api.actions.VersionedWrite;
import de.adorsys.datasafe.metainfo.version.impl.version.types.LatestDFSVersion;
import de.adorsys.datasafe.privatestore.api.PasswordClearingInputStream;
import de.adorsys.datasafe.privatestore.api.PasswordClearingOutputStream;
import de.adorsys.datasafe.privatestore.api.PasswordClearingStream;
import de.adorsys.datasafe.types.api.actions.ListRequest;
import de.adorsys.datasafe.types.api.actions.ReadRequest;
import de.adorsys.datasafe.types.api.actions.RemoveRequest;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import de.adorsys.datasafe.types.api.resource.Version;
import de.adorsys.datasafe.types.api.resource.Versioned;
import java.lang.Override;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class LatestPrivateSpaceImplRuntimeDelegatable<V extends LatestDFSVersion> extends LatestPrivateSpaceImpl<V> {
    private final LatestPrivateSpaceImpl<V> delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public LatestPrivateSpaceImplRuntimeDelegatable(@Nullable OverridesRegistry context, V strategy,
            VersionedList<V> listService, VersionedRead<V> readService,
            VersionedRemove<V> removeService, VersionedWrite<V> writeService) {
        super(strategy, listService, readService, removeService, writeService);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(strategy, listService, readService, removeService, writeService);
        delegate = context != null ? context.findOverride(LatestPrivateSpaceImpl.class, argumentsCaptor) : null;
    }

    @Override
    public PasswordClearingStream<AbsoluteLocation<ResolvedResource>> list(
            ListRequest<UserIDAuth, PrivateResource> request) {
        if (null == delegate) {
            return super.list(request);
        } else {
            return delegate.list(request);
        }
    }

    @Override
    public Stream<Versioned<AbsoluteLocation<PrivateResource>, ResolvedResource, Version>> listWithDetails(
            ListRequest<UserIDAuth, PrivateResource> request) {
        if (null == delegate) {
            return super.listWithDetails(request);
        } else {
            return delegate.listWithDetails(request);
        }
    }

    @Override
    public PasswordClearingInputStream read(ReadRequest<UserIDAuth, PrivateResource> request) {
        if (null == delegate) {
            return super.read(request);
        } else {
            return delegate.read(request);
        }
    }

    @Override
    public void remove(RemoveRequest<UserIDAuth, PrivateResource> request) {
        if (null == delegate) {
            super.remove(request);
        } else {
            delegate.remove(request);
        }
    }

    @Override
    public void makeSurePasswordClearanceIsDone() {
        if (null == delegate) {
            super.makeSurePasswordClearanceIsDone();
        } else {
            delegate.makeSurePasswordClearanceIsDone();
        }
    }

    @Override
    public PasswordClearingOutputStream write(WriteRequest<UserIDAuth, PrivateResource> request) {
        if (null == delegate) {
            return super.write(request);
        } else {
            return delegate.write(request);
        }
    }

    @Override
    public V getStrategy() {
        if (null == delegate) {
            return super.getStrategy();
        } else {
            return delegate.getStrategy();
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, LatestPrivateSpaceImpl> ctorCaptor) {
        context.override(LatestPrivateSpaceImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor<V extends LatestDFSVersion> {
        private final V strategy;

        private final VersionedList<V> listService;

        private final VersionedRead<V> readService;

        private final VersionedRemove<V> removeService;

        private final VersionedWrite<V> writeService;

        private ArgumentsCaptor(V strategy, VersionedList<V> listService,
                VersionedRead<V> readService, VersionedRemove<V> removeService,
                VersionedWrite<V> writeService) {
            this.strategy = strategy;
            this.listService = listService;
            this.readService = readService;
            this.removeService = removeService;
            this.writeService = writeService;
        }

        public V getStrategy() {
            return strategy;
        }

        public VersionedList<V> getListService() {
            return listService;
        }

        public VersionedRead<V> getReadService() {
            return readService;
        }

        public VersionedRemove<V> getRemoveService() {
            return removeService;
        }

        public VersionedWrite<V> getWriteService() {
            return writeService;
        }
    }
}
